///////////////////////////////////////////////////
// !!!Open source!!! Use the file at your own risk.
///////////////////////////////////////////////////

#include <windows.h>
#include <stdio.h>
#include <math.h>

#include "..\Global\FSNavFlp.h"

#ifdef __cplusplus
extern "C" {
#endif

const char APP_NAME[]		= "WindowsINI";
const char INITIAL_DIR[]	= "InitialDir";

const char TEXT_APT[]		= "APT";
const char TEXT_ATIS[]		= "ATIS";
const char TEXT_RWY[]		= "RWY";
const char TEXT_IM[]		= "IM";
const char TEXT_MM[]		= "MM";
const char TEXT_OM[]		= "OM";
const char TEXT_ILS[]		= "ILS";
const char TEXT_ILSGS[]		= "ILS/GS";
const char TEXT_VORTAC[]	= "VORTAC";
const char TEXT_VORDME[]	= "VORDME";
const char TEXT_DME[]		= "DME";
const char TEXT_VOR[]		= "VOR";
const char TEXT_NDB[]		= "NDB";
const char TEXT_ISEC[]		= "ISEC";
const char TEXT_GPS[]		= "GPS";
const char TEXT_BOC[]		= "BOC";
const char TEXT_EOC[]		= "EOC";
const char TEXT_BOD[]		= "BOD";
const char TEXT_EOD[]		= "EOD";
const char TEXT_EOCBOD[]	= "EOCBOD";
const char TEXT_EODBOC[]	= "EODBOC";

HANDLE hThisModule;
char szIniFilePath[_MAX_PATH];

BOOL WINAPI DllMain(HANDLE hModule, DWORD dwReason, LPVOID lpReserved)
{
	char* pszTmp;

    switch(dwReason)
	{
    case DLL_PROCESS_ATTACH:
		hThisModule = hModule;

		if (GetModuleFileName(hThisModule, szIniFilePath, _MAX_PATH) == 0)
			return FALSE;

		pszTmp = strrchr(szIniFilePath, '\\');
		if (pszTmp == NULL)
			return FALSE;

		strcpy(pszTmp + 1, INI_FILE_NAME);
		break;
    case DLL_THREAD_ATTACH:
		break;
    case DLL_THREAD_DETACH:
		break;
    case DLL_PROCESS_DETACH:
		break;
    }
    return TRUE;
}

BOOL Export1(const PVOID pFlightPlan, FILE* pFile)
{
	FLPX_HEADER		FlpxHeader = { sizeof(FLPX_HEADER) };
	FLPX_WAYPOINT	WayPoint = { sizeof(FLPX_WAYPOINT) };
	int				nCommand, nIndex;
	const char*		pcszType;

	if (!FlpxGetHeader(pFlightPlan, &FlpxHeader))
		return FALSE;

	if (fprintf(pFile, "[AIRCRAFT]\n") < 0)
		return FALSE;
	if (fprintf(pFile, "NAME=%s\n", FlpxHeader.m_szAircraftName) < 0)
		return FALSE;
	if (fprintf(pFile, "FUELMEASURE=%u\n", FlpxHeader.m_uFuelMeasure) < 0)
		return FALSE;
	if (fprintf(pFile, "\n") < 0)
		return FALSE;

	if (FlpxHeader.m_DepartureAirport.m_bValid)
	{
		if (fprintf(pFile, "[DEPARTURE]\n") < 0)
			return FALSE;
		if (fprintf(pFile, "ID=%s\n", FlpxHeader.m_DepartureAirport.m_szId) < 0)
			return FALSE;
		if (fprintf(pFile, "NAME=%s\n", FlpxHeader.m_DepartureAirport.m_szName) < 0)
			return FALSE;
		if (fprintf(pFile, "ATISFREQ=%0.2f\n", FlpxHeader.m_DepartureAirport.m_fAtisFreq) < 0)
			return FALSE;
		if (fprintf(pFile, "LAT=%0.6f\n", FlpxHeader.m_DepartureAirport.m_fLat) < 0)
			return FALSE;
		if (fprintf(pFile, "LON=%0.6f\n", FlpxHeader.m_DepartureAirport.m_fLon) < 0)
			return FALSE;
		if (fprintf(pFile, "ELEVATION=%0.0f\n", FlpxHeader.m_DepartureAirport.m_fElevation) < 0)
			return FALSE;
		if (fprintf(pFile, "MAGVAR=%0.1f\n", FlpxHeader.m_DepartureAirport.m_fMagVar) < 0)
			return FALSE;
		if (fprintf(pFile, "\n") < 0)
			return FALSE;

		if (FlpxHeader.m_DepartureAirport.m_nRwy > 0)
		{
			for (nIndex = 0; nIndex < FlpxHeader.m_DepartureAirport.m_nRwy; nIndex++)
			{
				if (fprintf(pFile, "[DEPARTURERWY_%d]\n", nIndex + 1) < 0)
					return FALSE;
				if (fprintf(pFile, "ID=%s\n", FlpxHeader.m_DepartureAirport.m_Rwy[nIndex].m_szId) < 0)
					return FALSE;
				if (fprintf(pFile, "HEAD=%0.0f\n", FlpxHeader.m_DepartureAirport.m_Rwy[nIndex].m_fHead) < 0)
					return FALSE;
				if (fprintf(pFile, "LAT=%0.6f\n", FlpxHeader.m_DepartureAirport.m_Rwy[nIndex].m_fLat) < 0)
					return FALSE;
				if (fprintf(pFile, "LON=%0.6f\n", FlpxHeader.m_DepartureAirport.m_Rwy[nIndex].m_fLon) < 0)
					return FALSE;
				if (fprintf(pFile, "ELEVATION=%0.0f\n", FlpxHeader.m_DepartureAirport.m_Rwy[nIndex].m_fElevation) < 0)
					return FALSE;
				if (fprintf(pFile, "LENGTH=%0.0f\n", FlpxHeader.m_DepartureAirport.m_Rwy[nIndex].m_fLength) < 0)
					return FALSE;
				if (fprintf(pFile, "WIDTH=%0.0f\n", FlpxHeader.m_DepartureAirport.m_Rwy[nIndex].m_fWidth) < 0)
					return FALSE;
				if (fprintf(pFile, "ILSFREQ=%0.2f\n", FlpxHeader.m_DepartureAirport.m_Rwy[nIndex].m_fFreq) < 0)
					return FALSE;
				if (fprintf(pFile, "\n") < 0)
					return FALSE;
			}
		}
	}

	if (FlpxHeader.m_ArrivalAirport.m_bValid)
	{
		if (fprintf(pFile, "[ARRIVAL]\n") < 0)
			return FALSE;
		if (fprintf(pFile, "ID=%s\n", FlpxHeader.m_ArrivalAirport.m_szId) < 0)
			return FALSE;
		if (fprintf(pFile, "NAME=%s\n", FlpxHeader.m_ArrivalAirport.m_szName) < 0)
			return FALSE;
		if (fprintf(pFile, "ATISFREQ=%0.2f\n", FlpxHeader.m_ArrivalAirport.m_fAtisFreq) < 0)
			return FALSE;
		if (fprintf(pFile, "LAT=%0.6f\n", FlpxHeader.m_ArrivalAirport.m_fLat) < 0)
			return FALSE;
		if (fprintf(pFile, "LON=%0.6f\n", FlpxHeader.m_ArrivalAirport.m_fLon) < 0)
			return FALSE;
		if (fprintf(pFile, "ELEVATION=%0.0f\n", FlpxHeader.m_ArrivalAirport.m_fElevation) < 0)
			return FALSE;
		if (fprintf(pFile, "MAGVAR=%0.1f\n", FlpxHeader.m_ArrivalAirport.m_fMagVar) < 0)
			return FALSE;
		if (fprintf(pFile, "\n") < 0)
			return FALSE;

		if (FlpxHeader.m_ArrivalAirport.m_nRwy > 0)
		{
			for (nIndex = 0; nIndex < FlpxHeader.m_ArrivalAirport.m_nRwy; nIndex++)
			{
				if (fprintf(pFile, "[ARRIVALRWY_%d]\n", nIndex + 1) < 0)
					return FALSE;
				if (fprintf(pFile, "ID=%s\n", FlpxHeader.m_ArrivalAirport.m_Rwy[nIndex].m_szId) < 0)
					return FALSE;
				if (fprintf(pFile, "HEAD=%0.0f\n", FlpxHeader.m_ArrivalAirport.m_Rwy[nIndex].m_fHead) < 0)
					return FALSE;
				if (fprintf(pFile, "LAT=%0.6f\n", FlpxHeader.m_ArrivalAirport.m_Rwy[nIndex].m_fLat) < 0)
					return FALSE;
				if (fprintf(pFile, "LON=%0.6f\n", FlpxHeader.m_ArrivalAirport.m_Rwy[nIndex].m_fLon) < 0)
					return FALSE;
				if (fprintf(pFile, "ELEVATION=%0.0f\n", FlpxHeader.m_ArrivalAirport.m_Rwy[nIndex].m_fElevation) < 0)
					return FALSE;
				if (fprintf(pFile, "LENGTH=%0.0f\n", FlpxHeader.m_ArrivalAirport.m_Rwy[nIndex].m_fLength) < 0)
					return FALSE;
				if (fprintf(pFile, "WIDTH=%0.0f\n", FlpxHeader.m_ArrivalAirport.m_Rwy[nIndex].m_fWidth) < 0)
					return FALSE;
				if (fprintf(pFile, "ILSFREQ=%0.2f\n", FlpxHeader.m_ArrivalAirport.m_Rwy[nIndex].m_fFreq) < 0)
					return FALSE;
				if (fprintf(pFile, "\n") < 0)
					return FALSE;
			}
		}
	}

	if (FlpxHeader.m_AlternateAirport.m_bValid)
	{
		if (fprintf(pFile, "[ALTERNATE]\n") < 0)
			return FALSE;
		if (fprintf(pFile, "ID=%s\n", FlpxHeader.m_AlternateAirport.m_szId) < 0)
			return FALSE;
		if (fprintf(pFile, "NAME=%s\n", FlpxHeader.m_AlternateAirport.m_szName) < 0)
			return FALSE;
		if (fprintf(pFile, "ATISFREQ=%0.2f\n", FlpxHeader.m_AlternateAirport.m_fAtisFreq) < 0)
			return FALSE;
		if (fprintf(pFile, "LAT=%0.6f\n", FlpxHeader.m_AlternateAirport.m_fLat) < 0)
			return FALSE;
		if (fprintf(pFile, "LON=%0.6f\n", FlpxHeader.m_AlternateAirport.m_fLon) < 0)
			return FALSE;
		if (fprintf(pFile, "ELEVATION=%0.0f\n", FlpxHeader.m_AlternateAirport.m_fElevation) < 0)
			return FALSE;
		if (fprintf(pFile, "MAGVAR=%0.1f\n", FlpxHeader.m_AlternateAirport.m_fMagVar) < 0)
			return FALSE;
		if (fprintf(pFile, "\n") < 0)
			return FALSE;

		if (FlpxHeader.m_AlternateAirport.m_nRwy > 0)
		{
			for (nIndex = 0; nIndex < FlpxHeader.m_AlternateAirport.m_nRwy; nIndex++)
			{
				if (fprintf(pFile, "[ALTERNATERWY_%d]\n", nIndex + 1) < 0)
					return FALSE;
				if (fprintf(pFile, "ID=%s\n", FlpxHeader.m_AlternateAirport.m_Rwy[nIndex].m_szId) < 0)
					return FALSE;
				if (fprintf(pFile, "HEAD=%0.0f\n", FlpxHeader.m_AlternateAirport.m_Rwy[nIndex].m_fHead) < 0)
					return FALSE;
				if (fprintf(pFile, "LAT=%0.6f\n", FlpxHeader.m_AlternateAirport.m_Rwy[nIndex].m_fLat) < 0)
					return FALSE;
				if (fprintf(pFile, "LON=%0.6f\n", FlpxHeader.m_AlternateAirport.m_Rwy[nIndex].m_fLon) < 0)
					return FALSE;
				if (fprintf(pFile, "ELEVATION=%0.0f\n", FlpxHeader.m_AlternateAirport.m_Rwy[nIndex].m_fElevation) < 0)
					return FALSE;
				if (fprintf(pFile, "LENGTH=%0.0f\n", FlpxHeader.m_AlternateAirport.m_Rwy[nIndex].m_fLength) < 0)
					return FALSE;
				if (fprintf(pFile, "WIDTH=%0.0f\n", FlpxHeader.m_AlternateAirport.m_Rwy[nIndex].m_fWidth) < 0)
					return FALSE;
				if (fprintf(pFile, "ILSFREQ=%0.2f\n", FlpxHeader.m_AlternateAirport.m_Rwy[nIndex].m_fFreq) < 0)
					return FALSE;
				if (fprintf(pFile, "\n") < 0)
					return FALSE;
			}
		}
	}

	for (nIndex = 1, nCommand = FLPX_GETFIRST; FlpxGetWaypoint(pFlightPlan, nCommand, &WayPoint); nCommand = FLPX_GETNEXT, nIndex++)
	{
		if (fprintf(pFile, "[WAYPOINT_%d]\n", nIndex) < 0)
			return FALSE;

		switch (WayPoint.m_cType)
		{
		case WPTYPE_APT:	pcszType = TEXT_APT; break;
		case WPTYPE_ATIS:	pcszType = TEXT_ATIS; break;
		case WPTYPE_RWY:	pcszType = TEXT_RWY; break;
		case WPTYPE_IM:		pcszType = TEXT_IM; break;
		case WPTYPE_MM:		pcszType = TEXT_MM; break;
		case WPTYPE_OM:		pcszType = TEXT_OM; break;
		case WPTYPE_ILS:	pcszType = TEXT_ILS; break;
		case WPTYPE_ILSGS:	pcszType = TEXT_ILSGS; break;
		case WPTYPE_VORTAC:	pcszType = TEXT_VORTAC; break;
		case WPTYPE_VORDME:	pcszType = TEXT_VORDME; break;
		case WPTYPE_DME:	pcszType = TEXT_DME; break;
		case WPTYPE_VOR:	pcszType = TEXT_VOR; break;
		case WPTYPE_NDB:	pcszType = TEXT_NDB; break;
		case WPTYPE_ISEC:	pcszType = TEXT_ISEC; break;
		case WPTYPE_GPS:	pcszType = TEXT_GPS; break;
		case WPTYPE_BOC:	pcszType = TEXT_BOC; break;
		case WPTYPE_EOC:	pcszType = TEXT_EOC; break;
		case WPTYPE_BOD:	pcszType = TEXT_BOD; break;
		case WPTYPE_EOD:	pcszType = TEXT_EOD; break;
		case WPTYPE_EOCBOD:	pcszType = TEXT_EOCBOD; break;
		case WPTYPE_EODBOC:	pcszType = TEXT_EODBOC; break;
		default:			pcszType = ""; break;
		}

		if (fprintf(pFile, "ID=%.5s\n", WayPoint.m_szId) < 0)
			return FALSE;
		if (fprintf(pFile, "NAME=%.30s\n", WayPoint.m_szName) < 0)
			return FALSE;
		if (fprintf(pFile, "TYPE=%s\n", pcszType) < 0)
			return FALSE;
		if (fprintf(pFile, "LAT=%0.6f\n", WayPoint.m_fLat) < 0)
			return FALSE;
		if (fprintf(pFile, "LON=%0.6f\n", WayPoint.m_fLon) < 0)
			return FALSE;
		if (fprintf(pFile, "HEADING=%0.0f\n", WayPoint.m_fHead) < 0)
			return FALSE;
		if (fprintf(pFile, "SPEED=%0.0f\n", WayPoint.m_fSpeed) < 0)
			return FALSE;
		if (fprintf(pFile, "TAS=%0.0f\n", WayPoint.m_fTAS) < 0)
			return FALSE;
		if (fprintf(pFile, "IAS=%0.0f\n", WayPoint.m_fIAS) < 0)
			return FALSE;
		if (fprintf(pFile, "MACH=%0.0f\n", WayPoint.m_fMach) < 0)
			return FALSE;
		if (fprintf(pFile, "VSPEED=%0.0f\n", WayPoint.m_fVSpeed) < 0)
			return FALSE;
		if (fprintf(pFile, "ALT=%0.0f\n", WayPoint.m_fAlt) < 0)
			return FALSE;
		if (fprintf(pFile, "DIST=%0.1f\n", WayPoint.m_fDist) < 0)
			return FALSE;
		if (fprintf(pFile, "ETE=%0.1f\n", WayPoint.m_fEte) < 0)
			return FALSE;
		if (fprintf(pFile, "FUEL=%0.0f\n", WayPoint.m_fFuel) < 0)
			return FALSE;
		if (fprintf(pFile, "FREQ=%0.2f\n", WayPoint.m_fFreq) < 0)
			return FALSE;
		if (fprintf(pFile, "\n") < 0)
			return FALSE;
	}

	return TRUE;
}

BOOL __stdcall Export(const PVOID pFlightPlan, HWND hwndParent)
{
	FILE*			pFile;
	char			szInitialDir[_MAX_PATH], szFileName[_MAX_PATH], szTmp[100];
	char*			pszTmp;
	BOOL			bResult = TRUE;

	GetPrivateProfileString(APP_NAME, INITIAL_DIR, "", szInitialDir, sizeof(szInitialDir), szIniFilePath);

	sprintf(szTmp, "%s Flight Plan (*.ini)|*.ini|All Files (*.*)|*.*||", APP_NAME);
	if (!FlpxDlgSaveAs(szFileName, hwndParent, szTmp, szInitialDir, "ini", NULL))
		return TRUE;

	strcpy(szInitialDir, szFileName);
	if (pszTmp = strrchr(szInitialDir, '\\'))
		*(pszTmp + 1) = '\0';
	WritePrivateProfileString(APP_NAME, INITIAL_DIR, szInitialDir, szIniFilePath);

	if ((pFile = fopen(szFileName, "wt")) == NULL)
		return FALSE;
	
	bResult = Export1(pFlightPlan, pFile);

	if (fclose(pFile) == EOF)
		bResult = FALSE;

	return bResult;
}

FLPX_IMPORT_TABLE FlpxImportTable =
{
	sizeof(FLPX_IMPORT_TABLE),
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};

FLPX_EXPORT_TABLE FlpxExportTable =
{
	sizeof(FLPX_EXPORT_TABLE),
	APP_NAME,
	NULL,
	Export
};

#ifdef __cplusplus
}
#endif
