///////////////////////////////////////////////////
// !!!Open source!!! Use the file at your own risk.
///////////////////////////////////////////////////

#include <windows.h>
#include <stdio.h>
#include <math.h>

#include "resource.h"
#include "..\Global\FSNavFlp.h"

#ifdef __cplusplus
extern "C" {
#endif

const char APP_NAME[]		= "UniversalText";
const char INITIAL_DIR[]	= "InitialDir";

HANDLE hThisModule;
char szIniFilePath[_MAX_PATH];
FLPX_HEADER FlpxHeader = { sizeof(FLPX_HEADER) };

BOOL WINAPI DllMain(HANDLE hModule, DWORD dwReason, LPVOID lpReserved)
{
	char* pszTmp;

    switch(dwReason)
	{
    case DLL_PROCESS_ATTACH:
		hThisModule = hModule;

		if (GetModuleFileName(hThisModule, szIniFilePath, _MAX_PATH) == 0)
			return FALSE;

		pszTmp = strrchr(szIniFilePath, '\\');
		if (pszTmp == NULL)
			return FALSE;

		strcpy(pszTmp + 1, INI_FILE_NAME);
		break;
    case DLL_THREAD_ATTACH:
		break;
    case DLL_THREAD_DETACH:
		break;
    case DLL_PROCESS_DETACH:
		break;
    }
    return TRUE;
}

BOOL Export1(const PVOID pFlightPlan, HWND hwndParent, FILE* pFile)
{
	char szTmp1[100], szTmp2[100];
	int nCommand, nWaypoint;
	FLPX_WAYPOINT	WayPoint = { sizeof(FLPX_WAYPOINT) };
	FLPX_WAYPOINT	WayPointPrev = { sizeof(FLPX_WAYPOINT) };
	double fLatRnd, fLonRnd, fYMin, fXMin;
	int nYDeg, nXDeg;
	char cYDir, cXDir;
	double fDist, fETE;
	double fDistSum = 0;
	double fETESum = 0;
	double fFuelSum = 0;
	double fSpeedMax = 0;
	double fAltMax = 0;

	for (nCommand = FLPX_GETFIRST; FlpxGetWaypoint(pFlightPlan, nCommand, &WayPoint); nCommand = FLPX_GETNEXT)
	{
		fDistSum += WayPoint.m_fDist;
		fETESum += WayPoint.m_fEte;
		fFuelSum += WayPoint.m_fFuel;
		if (WayPoint.m_fSpeed > fSpeedMax)
			fSpeedMax = WayPoint.m_fSpeed;
		if (WayPoint.m_fAlt > fAltMax)
			fAltMax = WayPoint.m_fAlt;
	}

	if (fprintf(pFile, "#   Type:     Name:                                       Frequency:  Course:  Dist.:  Time:\n") < 0)
		return FALSE;

	if (fprintf(pFile, "============================================================================================\n") < 0)
		return FALSE;

	sprintf(szTmp1, "%.80s [%.5s]", FlpxHeader.m_DepartureAirport.m_szName, FlpxHeader.m_DepartureAirport.m_szId);
	sprintf(szTmp2, "%6.2f", FlpxHeader.m_DepartureAirport.m_fAtisFreq);

	if (fprintf(pFile, "    Depart:   %-43.43s ATC: %s        %5.0f nm  %02u:%02u\n",
		szTmp1, FlpxHeader.m_DepartureAirport.m_fAtisFreq != 0 ? szTmp2 : "n.a.  ", .0, 0, 0) < 0)
		return FALSE;

	sprintf(szTmp1, "%.80s [%.5s]", FlpxHeader.m_ArrivalAirport.m_szName, FlpxHeader.m_ArrivalAirport.m_szId);
	sprintf(szTmp2, "%6.2f", FlpxHeader.m_ArrivalAirport.m_fAtisFreq);

	if (fprintf(pFile, "    Arrive:   %-43.43s ATC: %s        %5.0f nm  %02u:%02u\n",
		szTmp1, FlpxHeader.m_ArrivalAirport.m_fAtisFreq != 0 ? szTmp2 : "n.a.  ", fDistSum, (UINT)(fETESum / 60), (UINT)fmod(fETESum, 60)) < 0)
		return FALSE;

	if (fprintf(pFile, "============================================================================================\n") < 0)
		return FALSE;

	if (fprintf(pFile, "    Aircraft: %s\n", FlpxHeader.m_szAircraftName) < 0)
		return FALSE;
	
	if (fprintf(pFile, "    Cruise:   %0.0f kts\n", fSpeedMax) < 0)
		return FALSE;
	
	if (fprintf(pFile, "============================================================================================\n") < 0)
		return FALSE;

	nWaypoint = 0;
	for (nCommand = FLPX_GETFIRST; FlpxGetWaypoint(pFlightPlan, nCommand, &WayPoint); nCommand = FLPX_GETNEXT)
	{
		
		if (nWaypoint == 1)
		{
			if (WayPointPrev.m_cType == WPTYPE_RWY)
				sprintf(szTmp1, "%.80s - Rwy %.3s", FlpxHeader.m_DepartureAirport.m_szName, WayPointPrev.m_szId);
			else if (WayPointPrev.m_cType == WPTYPE_APT)
				sprintf(szTmp1, "%.80s [%.5s]", FlpxHeader.m_DepartureAirport.m_szName, FlpxHeader.m_DepartureAirport.m_szId);
			else
				return FALSE;

			sprintf(szTmp2, "%6.2f", FlpxHeader.m_DepartureAirport.m_fAtisFreq);

			if (fprintf(pFile, "%-3d Depart:   %-43.43s ATC : %s           0 nm  00:00\n",
				nWaypoint,
				szTmp1,
				FlpxHeader.m_DepartureAirport.m_fAtisFreq != 0 ? szTmp2 : "n.a.  ") < 0)
				return FALSE;

			if (fprintf(pFile, "              --> Climb to %.0f feet.\n", fAltMax) < 0)
				return FALSE;

			fDist = fETE = 0;
		}
		else if (nWaypoint > 1)
		{
			switch (WayPointPrev.m_cType)
			{
			case WPTYPE_IM:
			case WPTYPE_MM:
			case WPTYPE_OM:
				sprintf(szTmp1, "%.80s", WayPointPrev.m_szName);

				if (fprintf(pFile, "%-3d Waypoint: %-42.42s                 %3.0f %4.0f nm  %02u:%02u\n",
					nWaypoint,
					szTmp1,
					WayPointPrev.m_fHead,
					WayPointPrev.m_fDist + fDist,
					(UINT)((WayPointPrev.m_fEte + fETE) / 60),
					(UINT)fmod(WayPointPrev.m_fEte + fETE, 60)) < 0)
					return FALSE;

				fDist = fETE = 0;
				break;
			case WPTYPE_ATIS:
				sprintf(szTmp1, "%.80s", WayPointPrev.m_szName);

				if (fprintf(pFile, "%-3d Waypoint: %-43.43s ATIS: %6.2f   %3.0f %4.0f nm  %02u:%02u\n",
					nWaypoint,
					szTmp1,
					WayPointPrev.m_fFreq,
					WayPointPrev.m_fHead,
					WayPointPrev.m_fDist + fDist,
					(UINT)((WayPointPrev.m_fEte + fETE) / 60),
					(UINT)fmod(WayPointPrev.m_fEte + fETE, 60)) < 0)
					return FALSE;

				fDist = fETE = 0;
				break;
			case WPTYPE_VORTAC:
			case WPTYPE_VORDME:
			case WPTYPE_DME:
			case WPTYPE_VOR:
				sprintf(szTmp1, "%.80s [%.5s]", WayPointPrev.m_szName, WayPointPrev.m_szId);

				if (fprintf(pFile, "%-3d Waypoint: %-43.43s VOR : %6.2f   %3.0f %4.0f nm  %02u:%02u\n",
					nWaypoint,
					szTmp1,
					WayPointPrev.m_fFreq,
					WayPointPrev.m_fHead,
					WayPointPrev.m_fDist + fDist,
					(UINT)((WayPointPrev.m_fEte + fETE) / 60),
					(UINT)fmod(WayPointPrev.m_fEte + fETE, 60)) < 0)
					return FALSE;

				fDist = fETE = 0;
				break;
			case WPTYPE_NDB:
				sprintf(szTmp1, "%.80s [%.5s]", WayPointPrev.m_szName, WayPointPrev.m_szId);

				if (fprintf(pFile, "%-3d Waypoint: %-43.43s NDB : %6.1f   %3.0f %4.0f nm  %02u:%02u\n",
					nWaypoint,
					szTmp1,
					WayPointPrev.m_fFreq,
					WayPointPrev.m_fHead,
					WayPointPrev.m_fDist + fDist,
					(UINT)((WayPointPrev.m_fEte + fETE) / 60),
					(UINT)fmod(WayPointPrev.m_fEte + fETE, 60)) < 0)
					return FALSE;

				fDist = fETE = 0;
				break;
			case WPTYPE_ISEC:
				sprintf(szTmp1, "Intersection [%.5s]", WayPointPrev.m_szId);

				if (fprintf(pFile, "%-3d Waypoint: %-42.42s                 %3.0f %4.0f nm  %02u:%02u\n",
					nWaypoint,
					szTmp1,
					WayPointPrev.m_fHead,
					WayPointPrev.m_fDist + fDist,
					(UINT)((WayPointPrev.m_fEte + fETE) / 60),
					(UINT)fmod(WayPointPrev.m_fEte + fETE, 60)) < 0)
					return FALSE;

				fDist = fETE = 0;
				break;
			case WPTYPE_GPS:
				fLatRnd = (int)WayPointPrev.m_fLat + floor((WayPointPrev.m_fLat - (int)WayPointPrev.m_fLat) * 60 * 100 + .5) / 60 / 100;
				nYDeg = (int)fLatRnd;
				fYMin = fabs((fLatRnd - nYDeg) * 60);
				cYDir = fLatRnd < 0 ? 'S' : 'N';
				nYDeg = abs(nYDeg);

				fLonRnd = (int)WayPointPrev.m_fLon + floor((WayPointPrev.m_fLon - (int)WayPointPrev.m_fLon) * 60 * 100 + .5) / 60 / 100;
				nXDeg = (int)fLonRnd;
				fXMin = fabs((fLonRnd - nXDeg) * 60);
				cXDir = fLonRnd < 0 ? 'W' : 'E';
				nXDeg = abs(nXDeg);

				sprintf(szTmp1, "%s [%c%d %2.2f', %c%d %2.2f']", WayPointPrev.m_szName, cYDir, nYDeg, fYMin, cXDir, nXDeg, fXMin);

				if (fprintf(pFile, "%-3d Waypoint: %-42.42s                 %3.0f %4.0f nm  %02u:%02u\n",
					nWaypoint,
					szTmp1,
					WayPointPrev.m_fHead,
					WayPointPrev.m_fDist + fDist,
					(UINT)((WayPointPrev.m_fEte + fETE) / 60),
					(UINT)fmod(WayPointPrev.m_fEte + fETE, 60)) < 0)
					return FALSE;

				fDist = fETE = 0;
				break;
			case WPTYPE_BOC:
			case WPTYPE_EOC:
			case WPTYPE_BOD:
			case WPTYPE_EOD:
			case WPTYPE_EOCBOD:
			case WPTYPE_EODBOC:
				fDist = WayPointPrev.m_fDist;
				fETE = WayPointPrev.m_fEte;
				break;
			default:
				return FALSE;
			}
		}

		WayPointPrev = WayPoint;
		nWaypoint++;
	}

	if (fprintf(pFile, "--------------------------------------------------------------------------------------------\n") < 0)
		return FALSE;

	if (WayPointPrev.m_cType == WPTYPE_RWY)
		sprintf(szTmp1, "%.80s - Rwy %.3s", FlpxHeader.m_ArrivalAirport.m_szName, WayPointPrev.m_szId);
	else if (WayPointPrev.m_cType == WPTYPE_ILS || WayPointPrev.m_cType == WPTYPE_ILSGS)
		sprintf(szTmp1, "%.80s - ILS %.3s", FlpxHeader.m_ArrivalAirport.m_szName, WayPointPrev.m_szId);
	else if (WayPointPrev.m_cType == WPTYPE_APT)
		sprintf(szTmp1, "%.80s [%.5s]", FlpxHeader.m_ArrivalAirport.m_szName, FlpxHeader.m_ArrivalAirport.m_szId);
	else
		return FALSE;

	sprintf(szTmp2, "%6.2f", FlpxHeader.m_ArrivalAirport.m_fAtisFreq);

	if (fprintf(pFile, "%-3d Arrive:   %-43.43s ATC : %s   %3.0f %4.0f nm  %02u:%02u\n",
		nWaypoint,
		szTmp1,
		FlpxHeader.m_ArrivalAirport.m_fAtisFreq != 0 ? szTmp2 : "n.a.  ",
		WayPointPrev.m_fHead,
		WayPointPrev.m_fDist + fDist,
		(UINT)((WayPointPrev.m_fEte + fETE) / 60),
		(UINT)fmod(WayPointPrev.m_fEte + fETE, 60)) < 0)
		return FALSE;

	if (WayPointPrev.m_cType == WPTYPE_RWY)
	{
		sprintf(szTmp1, "Runway heading %.0f, altitude %.0f ft", WayPointPrev.m_fHead, WayPointPrev.m_fAlt);
		sprintf(szTmp2, "%6.2f", WayPointPrev.m_fFreq);

		if (fprintf(pFile, "              %-43.43s ILS : %s\n", szTmp1, WayPointPrev.m_fFreq != 0 ? szTmp2 : "n.a.  ") < 0)
			return FALSE;
	}
	else if (WayPointPrev.m_cType == WPTYPE_ILS || WayPointPrev.m_cType == WPTYPE_ILSGS)
	{
		sprintf(szTmp1, "ILS heading %.0f, altitude %.0f ft", WayPointPrev.m_fHead, WayPointPrev.m_fAlt);
		sprintf(szTmp2, "%6.2f", WayPointPrev.m_fFreq);

		if (fprintf(pFile, "              %-43.43s ILS : %s\n", szTmp1, WayPointPrev.m_fFreq != 0 ? szTmp2 : "n.a.  ") < 0)
			return FALSE;
	}
	else if (WayPointPrev.m_cType == WPTYPE_APT)
	{
		sprintf(szTmp1, "Airport altitude %.0f ft", WayPointPrev.m_fAlt);

		if (fprintf(pFile, "              %-43.43s\n", szTmp1) < 0)
			return FALSE;
	}
	else
		return FALSE;

	if (fprintf(pFile, "============================================================================================\n") < 0)
		return FALSE;

	switch (FlpxHeader.m_uFuelMeasure)
	{
	case FUEL_MEASURE_LBS: strcpy(szTmp2, "Lbs"); break;
	case FUEL_MEASURE_GAL: strcpy(szTmp2, "Gal"); break;
	case FUEL_MEASURE_KG: strcpy(szTmp2, "kg"); break;
	case FUEL_MEASURE_L: strcpy(szTmp2, "L"); break;
	default: strcpy(szTmp2, ""); break;
	}
	sprintf(szTmp1, "(%.0f %s fuel required)", fFuelSum, szTmp2);

	if (fprintf(pFile, "    Total:    %-43.43s                    %5.0f nm  %02u:%02u\n",
		szTmp1, fDistSum, (UINT)(fETESum / 60), (UINT)fmod(fETESum, 60)) < 0)
		return FALSE;

	return TRUE;
}


BOOL __stdcall Export(const PVOID pFlightPlan, HWND hwndParent)
{
	FILE*			pFile;
	char			szInitialDir[_MAX_PATH], szFileName[_MAX_PATH], szTmp[100];
	char*			pszTmp;
	BOOL			bResult = TRUE;

	if (!FlpxGetHeader(pFlightPlan, &FlpxHeader) || !FlpxHeader.m_DepartureAirport.m_bValid || !FlpxHeader.m_ArrivalAirport.m_bValid)
		return FALSE;

	GetPrivateProfileString(APP_NAME, INITIAL_DIR, "", szInitialDir, sizeof(szInitialDir), szIniFilePath);

	sprintf(szTmp, "%s Flight Plan (*.txt)|*.txt|All Files (*.*)|*.*||", APP_NAME);
	if (!FlpxDlgSaveAs(szFileName, hwndParent, szTmp, szInitialDir, "prg", NULL))
		return TRUE;

	strcpy(szInitialDir, szFileName);
	if (pszTmp = strrchr(szInitialDir, '\\'))
		*(pszTmp + 1) = '\0';
	WritePrivateProfileString(APP_NAME, INITIAL_DIR, szInitialDir, szIniFilePath);

	if ((pFile = fopen(szFileName, "wt")) == NULL)
		return FALSE;

	bResult = Export1(pFlightPlan, hwndParent, pFile);

	if (fclose(pFile) == EOF)
		bResult = FALSE;

	return bResult;
}

FLPX_IMPORT_TABLE FlpxImportTable =
{
	sizeof(FLPX_IMPORT_TABLE),
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};

FLPX_EXPORT_TABLE FlpxExportTable =
{
	sizeof(FLPX_EXPORT_TABLE),
	APP_NAME,
	NULL,
	Export
};

#ifdef __cplusplus
}
#endif
