///////////////////////////////////////////////////
// !!!Open source!!! Use the file at your own risk.
///////////////////////////////////////////////////

#include <windows.h>
#include <stdio.h>
#include <math.h>

#include "resource.h"
#include "..\Global\FSNavFlp.h"

#ifdef __cplusplus
extern "C" {
#endif

const char APP_NAME[]		= "SquawkBox";
const char INITIAL_DIR[]	= "InitialDir";
const char CROSSING_SPEED[]	= "CrossingSpeed";
const char CROSSING_ALT[]	= "CrossingAltitude";
const char AFTER_ALT[]		= "AltitudeAfter";
const char AFTER_HEAD[]		= "HeadingAfter";

HANDLE hThisModule;
char szIniFilePath[_MAX_PATH];

BOOL WINAPI DllMain(HANDLE hModule, DWORD dwReason, LPVOID lpReserved)
{
	char* pszTmp;

    switch(dwReason)
	{
    case DLL_PROCESS_ATTACH:
		hThisModule = hModule;

		if (GetModuleFileName(hThisModule, szIniFilePath, _MAX_PATH) == 0)
			return FALSE;

		pszTmp = strrchr(szIniFilePath, '\\');
		if (pszTmp == NULL)
			return FALSE;

		strcpy(pszTmp + 1, INI_FILE_NAME);
		break;
    case DLL_THREAD_ATTACH:
		break;
    case DLL_THREAD_DETACH:
		break;
    case DLL_PROCESS_DETACH:
		break;
    }
    return TRUE;
}

BOOL CALLBACK DialogProcOptions(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	WORD wNotifyCode, wID;
	HWND hwndCtl;
	char szTmp[1000];
	LRESULT lResult;

	switch (uMsg)
	{
	case WM_INITDIALOG:
		strcpy(szTmp, APP_NAME);
		strcat(szTmp, " ");
		GetWindowText(hwndDlg, &szTmp[strlen(szTmp)], sizeof(szTmp) - strlen(szTmp));
		SetWindowText(hwndDlg, szTmp);

		GetPrivateProfileString(APP_NAME, CROSSING_SPEED, "1", szTmp, sizeof(szTmp), szIniFilePath);
		SendMessage(GetDlgItem(hwndDlg, IDC_CROSSING_SPEED), BM_SETCHECK, (szTmp[0] == '0' ? BST_UNCHECKED : BST_CHECKED), 0);

		GetPrivateProfileString(APP_NAME, CROSSING_ALT, "1", szTmp, sizeof(szTmp), szIniFilePath);
		SendMessage(GetDlgItem(hwndDlg, IDC_CROSSING_ALT), BM_SETCHECK, (szTmp[0] == '0' ? BST_UNCHECKED : BST_CHECKED), 0);

		GetPrivateProfileString(APP_NAME, AFTER_ALT, "1", szTmp, sizeof(szTmp), szIniFilePath);
		SendMessage(GetDlgItem(hwndDlg, IDC_AFTER_ALT), BM_SETCHECK, (szTmp[0] == '0' ? BST_UNCHECKED : BST_CHECKED), 0);

		GetPrivateProfileString(APP_NAME, AFTER_HEAD, "1", szTmp, sizeof(szTmp), szIniFilePath);
		SendMessage(GetDlgItem(hwndDlg, IDC_AFTER_HEAD), BM_SETCHECK, (szTmp[0] == '0' ? BST_UNCHECKED : BST_CHECKED), 0);
		break;
	case WM_COMMAND:
		wNotifyCode = HIWORD(wParam);
		wID = LOWORD(wParam);
		hwndCtl = (HWND)lParam;

		if (hwndCtl != NULL && wNotifyCode == BN_CLICKED)
		{
			switch (wID)
			{
			case IDCANCEL:
				EndDialog(hwndDlg, IDCANCEL);
				return 1;
				break;
			case IDOK:
				EndDialog(hwndDlg, IDOK);

				lResult = SendMessage(GetDlgItem(hwndDlg, IDC_CROSSING_SPEED), BM_GETCHECK, 0, 0);
				WritePrivateProfileString(APP_NAME, CROSSING_SPEED, (lResult == BST_CHECKED ? "1" : "0"), szIniFilePath);

				lResult = SendMessage(GetDlgItem(hwndDlg, IDC_CROSSING_ALT), BM_GETCHECK, 0, 0);
				WritePrivateProfileString(APP_NAME, CROSSING_ALT, (lResult == BST_CHECKED ? "1" : "0"), szIniFilePath);

				lResult = SendMessage(GetDlgItem(hwndDlg, IDC_AFTER_ALT), BM_GETCHECK, 0, 0);
				WritePrivateProfileString(APP_NAME, AFTER_ALT, (lResult == BST_CHECKED ? "1" : "0"), szIniFilePath);

				lResult = SendMessage(GetDlgItem(hwndDlg, IDC_AFTER_HEAD), BM_GETCHECK, 0, 0);
				WritePrivateProfileString(APP_NAME, AFTER_HEAD, (lResult == BST_CHECKED ? "1" : "0"), szIniFilePath);
				return 1;
				break;
			}
		}
		break;
	}

	return 0;
}

void __stdcall Options(const PVOID pFlightPlan, HWND hwndParent)
{
	DialogBox(hThisModule, MAKEINTRESOURCE(IDD_OPTIONS), hwndParent, DialogProcOptions);
}

BOOL __stdcall Export(const PVOID pFlightPlan, HWND hwndParent)
{
	FILE*			pFile;
	FLPX_HEADER		FlpxHeader = { sizeof(FLPX_HEADER) };
	FLPX_WAYPOINT	WayPoint1 = { sizeof(FLPX_WAYPOINT) };
	FLPX_WAYPOINT	WayPoint2 = { sizeof(FLPX_WAYPOINT) };
	FLPX_WAYPOINT	WayPoint3 = { sizeof(FLPX_WAYPOINT) };
	double			fSpeed;
	BOOL			bWayPoint2Valid;
	char			cType, szTmp[100], szInitialDir[_MAX_PATH], szFileName[_MAX_PATH];
	char*			pszTmp;
	int				nCommand;
	BOOL			bCrossingSpeed, bCrossingAlt, bAfterAlt, bAfterHead;
	BOOL			bResult = TRUE;

	GetPrivateProfileString(APP_NAME, INITIAL_DIR, "", szInitialDir, sizeof(szInitialDir), szIniFilePath);

	sprintf(szTmp, "%s Flight Plan (*.sbp)|*.sbp|All Files (*.*)|*.*||", APP_NAME);
	if (!FlpxDlgSaveAs(szFileName, hwndParent, szTmp, szInitialDir, "sbp", NULL))
		return TRUE;

	strcpy(szInitialDir, szFileName);
	if (pszTmp = strrchr(szInitialDir, '\\'))
		*(pszTmp + 1) = '\0';
	WritePrivateProfileString(APP_NAME, INITIAL_DIR, szInitialDir, szIniFilePath);

	GetPrivateProfileString(APP_NAME, CROSSING_SPEED, "1", szTmp, sizeof(szTmp), szIniFilePath);
	bCrossingSpeed = szTmp[0] != '0';

	GetPrivateProfileString(APP_NAME, CROSSING_ALT, "1", szTmp, sizeof(szTmp), szIniFilePath);
	bCrossingAlt = szTmp[0] != '0';

	GetPrivateProfileString(APP_NAME, AFTER_ALT, "1", szTmp, sizeof(szTmp), szIniFilePath);
	bAfterAlt = szTmp[0] != '0';

	GetPrivateProfileString(APP_NAME, AFTER_HEAD, "1", szTmp, sizeof(szTmp), szIniFilePath);
	bAfterHead = szTmp[0] != '0';

	if (!FlpxGetHeader(pFlightPlan, &FlpxHeader) || !FlpxHeader.m_DepartureAirport.m_bValid || !FlpxHeader.m_ArrivalAirport.m_bValid)
		return FALSE;

	fSpeed = 0;
	for (nCommand = FLPX_GETFIRST; FlpxGetWaypoint(pFlightPlan, nCommand, &WayPoint3); nCommand = FLPX_GETNEXT)
	{
		if (strlen(WayPoint3.m_szId) == 0)
			continue;

		if (WayPoint3.m_cType != WPTYPE_ISEC && WayPoint3.m_cType != WPTYPE_NDB &&
			WayPoint3.m_cType != WPTYPE_VORTAC && WayPoint3.m_cType != WPTYPE_VORDME &&
			WayPoint3.m_cType != WPTYPE_DME && WayPoint3.m_cType != WPTYPE_VOR)
			continue;

		if (WayPoint3.m_fTAS > fSpeed)
			fSpeed = WayPoint3.m_fTAS;
	}

	if ((pFile = fopen(szFileName, "wt")) == NULL)
		return FALSE;

	if (bResult = fprintf(pFile, "%.5s:%.5s:%0.0f\n", FlpxHeader.m_DepartureAirport.m_szId, FlpxHeader.m_ArrivalAirport.m_szId, fSpeed) >= 0)
	{
		bWayPoint2Valid = FALSE;
		for (nCommand = FLPX_GETFIRST; FlpxGetWaypoint(pFlightPlan, nCommand, &WayPoint1); nCommand = FLPX_GETNEXT)
		{
			if (bWayPoint2Valid)
			{
				if (WayPoint2.m_cType == WPTYPE_ISEC)
					cType = 'I';
				else if (WayPoint2.m_cType == WPTYPE_NDB)
					cType = 'N';
				else if (WayPoint2.m_cType == WPTYPE_VORTAC || WayPoint2.m_cType == WPTYPE_VORDME ||
						 WayPoint2.m_cType == WPTYPE_DME || WayPoint2.m_cType == WPTYPE_VOR)
					cType = 'V';

				if (!(bResult = fprintf(pFile, "%c:%-5.5s:%0.6f:%0.6f:%0.0f:%0.0f:%0.0f:%0.0f\n",
												cType, WayPoint2.m_szId, WayPoint2.m_fLat, WayPoint2.m_fLon,
												(bCrossingSpeed ? WayPoint2.m_fCrossingSpeed : 0),
												(bCrossingAlt ? WayPoint2.m_fCrossingAlt : 0),
												(bAfterAlt ? WayPoint2.m_fAfterAlt : 0),
												(bAfterHead ? WayPoint1.m_fHead : 0)) >= 0))
					break;

				bWayPoint2Valid = FALSE;
			}

			if (WayPoint1.m_cType != WPTYPE_ISEC && WayPoint1.m_cType != WPTYPE_NDB &&
				WayPoint1.m_cType != WPTYPE_VORTAC && WayPoint1.m_cType != WPTYPE_VORDME &&
				WayPoint1.m_cType != WPTYPE_DME && WayPoint1.m_cType != WPTYPE_VOR)
				continue;

			WayPoint2 = WayPoint1;
			bWayPoint2Valid = TRUE;
		}

		bResult = bResult && fprintf(pFile, "\n") >= 0;
	}

	if (fclose(pFile) == EOF)
		bResult = FALSE;

	return bResult;
}

FLPX_IMPORT_TABLE FlpxImportTable =
{
	sizeof(FLPX_IMPORT_TABLE),
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};

FLPX_EXPORT_TABLE FlpxExportTable =
{
	sizeof(FLPX_EXPORT_TABLE),
	APP_NAME,
	Options,
	Export
};

#ifdef __cplusplus
}
#endif
