///////////////////////////////////////////////////
// !!!Open source!!! Use the file at your own risk.
///////////////////////////////////////////////////

#include <windows.h>
#include <Commctrl.h>
#include <stdio.h>
#include <math.h>

#include "resource.h"
#include "..\Global\FSNavFlp.h"

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_TITLE	59
#define MAX_DESCR	250

const char APP_NAME[]		= "RadarContact99";
const char INITIAL_DIR[]	= "InitialDir";
const char szLS[]			= "    ";

HANDLE		hThisModule;
char		szIniFilePath[_MAX_PATH];
char		szTitle[MAX_TITLE + 1];
char		szDescr[MAX_DESCR + 1];
FLPX_HEADER FlpxHeader = { sizeof(FLPX_HEADER) };
char		szHoldId[6];
double		fCruiseAlt;
int			nCheckpoints;
int			nAircraftType;


BOOL WINAPI DllMain(HANDLE hModule, DWORD dwReason, LPVOID lpReserved)
{
	char* pszTmp;

    switch(dwReason)
	{
    case DLL_PROCESS_ATTACH:
		hThisModule = hModule;

		if (GetModuleFileName(hThisModule, szIniFilePath, _MAX_PATH) == 0)
			return FALSE;

		pszTmp = strrchr(szIniFilePath, '\\');
		if (pszTmp == NULL)
			return FALSE;

		strcpy(pszTmp + 1, INI_FILE_NAME);
		break;
    case DLL_THREAD_ATTACH:
		break;
    case DLL_THREAD_DETACH:
		break;
    case DLL_PROCESS_DETACH:
		break;
    }
    return TRUE;
}

void SetRwyColumn(HWND hwndDlg, int nDlgItem)
{
	LV_COLUMN lvc;
	HWND hWnd;

	hWnd = GetDlgItem(hwndDlg, nDlgItem);

	SendMessage(hWnd, LVM_SETEXTENDEDLISTVIEWSTYLE, 0, LVS_EX_FULLROWSELECT);

	lvc.mask = LVCF_FMT | LVCF_SUBITEM | LVCF_TEXT;
	lvc.fmt = LVCFMT_LEFT;
	lvc.pszText = "Id";
	lvc.iSubItem = 0;
	SendMessage(hWnd, LVM_INSERTCOLUMN, lvc.iSubItem, (LPARAM)&lvc);
	lvc.fmt = LVCFMT_RIGHT;
	lvc.pszText = "Head";
	lvc.iSubItem = 1;
	SendMessage(hWnd, LVM_INSERTCOLUMN, lvc.iSubItem, (LPARAM)&lvc);
	lvc.fmt = LVCFMT_RIGHT;
	lvc.pszText = "Length";
	lvc.iSubItem = 2;
	SendMessage(hWnd, LVM_INSERTCOLUMN, lvc.iSubItem, (LPARAM)&lvc);
	lvc.fmt = LVCFMT_CENTER;
	lvc.pszText = "ILS";
	lvc.iSubItem = 3;
	SendMessage(hWnd, LVM_INSERTCOLUMN, lvc.iSubItem, (LPARAM)&lvc);
}

void SetRwyColumnWidth(HWND hwndDlg, int nDlgItem)
{
	HWND hWnd;
	RECT Rect;
	LONG lWidthWindow, lWidth;

	hWnd = GetDlgItem(hwndDlg, nDlgItem);
	GetClientRect(hWnd, &Rect);
	lWidthWindow = Rect.right - Rect.left;

	lWidth = lWidthWindow / 6;
	SendMessage(hWnd, LVM_SETCOLUMNWIDTH, 0, MAKELPARAM(lWidth, 0));
	lWidthWindow -=	lWidth;
	lWidth = lWidthWindow / 3;
	SendMessage(hWnd, LVM_SETCOLUMNWIDTH, 1, MAKELPARAM(lWidth, 0));
	lWidthWindow -=	lWidth;
	SendMessage(hWnd, LVM_SETCOLUMNWIDTH, 2, MAKELPARAM(lWidth, 0));
	lWidthWindow -=	lWidth;
	SendMessage(hWnd, LVM_SETCOLUMNWIDTH, 3, MAKELPARAM(lWidthWindow, 0));
}

void FormatRwyId(LPSTR lpszDest, LPCSTR lpcszSrc)
{
	LPCSTR lpcszTmp;
	int nDigit = 0;

	for (lpcszTmp = lpcszSrc; *lpcszTmp; lpcszTmp++)
		if (isdigit(*lpcszTmp))
			nDigit++;

	if (nDigit >= 2)
		sprintf(lpszDest, "%s", lpcszSrc);
	else
		sprintf(lpszDest, " %s", lpcszSrc);
}

void InsertRwyRow(HWND hwndDlg, int nDlgItem, int nRunway, FLPX_RUNWAY Runway[])
{
	HWND hWnd;
	LV_ITEM lvi;
	char szTmp[100];

	hWnd = GetDlgItem(hwndDlg, nDlgItem);

	lvi.iItem = 0;
	lvi.iSubItem = 0;
	lvi.mask = LVIF_TEXT | LVIF_PARAM;
	lvi.pszText = szTmp;
	lvi.lParam = nRunway;

	FormatRwyId(szTmp, Runway[nRunway].m_szId);
	lvi.iItem = SendMessage(hWnd, LVM_INSERTITEM, 0, (LPARAM)&lvi);

	lvi.mask = LVIF_TEXT;

	lvi.iSubItem = 1;
	sprintf(szTmp, "%0.0f", Runway[nRunway].m_fHead);
	SendMessage(hWnd, LVM_SETITEM, 0, (LPARAM)&lvi);

	lvi.iSubItem = 2;
	sprintf(szTmp, "%0.0f", Runway[nRunway].m_fLength);
	SendMessage(hWnd, LVM_SETITEM, 0, (LPARAM)&lvi);

	if (Runway[nRunway].m_fFreq != 0)
	{
		lvi.iSubItem = 3;
		sprintf(szTmp, "%0.2f", Runway[nRunway].m_fFreq);
		SendMessage(hWnd, LVM_SETITEM, 0, (LPARAM)&lvi);
	}
}

void MoveRwyRow(HWND hwndDlg, int nDlgItemFrom, int nDlgItemTo, FLPX_RUNWAY Runway[])
{
	HWND hWnd;
	LV_ITEM lvi;
	int nItem;

	hWnd = GetDlgItem(hwndDlg, nDlgItemFrom);

	for (nItem = SendMessage(hWnd, LVM_GETITEMCOUNT, 0, 0); nItem >= 0; nItem--)
	{
		if (SendMessage(hWnd, LVM_GETITEMSTATE, nItem, LVIS_SELECTED) != LVIS_SELECTED)
			continue;

		lvi.mask = LVIF_PARAM;
		lvi.iItem = nItem;
		lvi.iSubItem = 0;
		if (!SendMessage(hWnd, LVM_GETITEM, 0, (LPARAM)&lvi) || !SendMessage(hWnd, LVM_DELETEITEM, nItem, 0))
			continue;

		InsertRwyRow(hwndDlg, nDlgItemTo, lvi.lParam, Runway);
	}

	SetRwyColumnWidth(hwndDlg, nDlgItemFrom);
	SetRwyColumnWidth(hwndDlg, nDlgItemTo);
}

void OnOK(HWND hwndDlg, int nDlgItem, int* pnRunway, FLPX_RUNWAY Runway[])
{
	HWND hWnd;
	LV_ITEM lvi;
	int nItem, nRunway;
	FLPX_RUNWAY	RunwayNew[FLPX_MAX_RWY];

	memset(RunwayNew, 0, sizeof(RunwayNew));
	hWnd = GetDlgItem(hwndDlg, nDlgItem);
	nRunway = 0;

	for (nItem = SendMessage(hWnd, LVM_GETITEMCOUNT, 0, 0); nItem >= 0; nItem--)
	{
		lvi.mask = LVIF_PARAM;
		lvi.iItem = nItem;
		lvi.iSubItem = 0;
		if (!SendMessage(hWnd, LVM_GETITEM, 0, (LPARAM)&lvi))
			continue;

		RunwayNew[nRunway++] = Runway[lvi.lParam];
	}

	memcpy(Runway, RunwayNew, sizeof(RunwayNew));
	*pnRunway = nRunway;
}

BOOL CALLBACK DialogProcOptions(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	WORD wNotifyCode, wID;
	HWND hwndCtl;
	LPNMHDR pnmh;
	int nIndex, nItem, idCtrl;
	char szTmp[1000];

	switch (uMsg)
	{
	case WM_INITDIALOG:
		strcpy(szTmp, APP_NAME);
		strcat(szTmp, " ");
		GetWindowText(hwndDlg, &szTmp[strlen(szTmp)], sizeof(szTmp) - strlen(szTmp));
		SetWindowText(hwndDlg, szTmp);

		SendMessage(GetDlgItem(hwndDlg, IDC_TITLE), EM_LIMITTEXT, MAX_TITLE, 0);
		sprintf(szTmp, "%s to %s: %s",
				(FlpxHeader.m_DepartureAirport.m_szId[0] != '\0' ? FlpxHeader.m_DepartureAirport.m_szId : FlpxHeader.m_DepartureAirport.m_szName),
				(FlpxHeader.m_ArrivalAirport.m_szId[0] != '\0' ? FlpxHeader.m_ArrivalAirport.m_szId : FlpxHeader.m_ArrivalAirport.m_szName),
				FlpxHeader.m_szAircraftName);
		szTmp[MAX_TITLE] = '\0';
		SetWindowText(GetDlgItem(hwndDlg, IDC_TITLE), szTmp);

		SendMessage(GetDlgItem(hwndDlg, IDC_DESCRIPTION), EM_LIMITTEXT, MAX_DESCR, 0);
		sprintf(szTmp, "%s to %s - Aircraft: %s - FlightLevel: %0.0f",
				FlpxHeader.m_DepartureAirport.m_szName, FlpxHeader.m_ArrivalAirport.m_szName, FlpxHeader.m_szAircraftName, ceil(fCruiseAlt / 100));
		szTmp[MAX_DESCR] = '\0';
		SetWindowText(GetDlgItem(hwndDlg, IDC_DESCRIPTION), szTmp);

		EnableWindow(GetDlgItem(hwndDlg, IDC_DRWY_ADD), FALSE);
		EnableWindow(GetDlgItem(hwndDlg, IDC_DRWY_DEL), FALSE);
		EnableWindow(GetDlgItem(hwndDlg, IDC_ARWY_ADD), FALSE);
		EnableWindow(GetDlgItem(hwndDlg, IDC_ARWY_DEL), FALSE);

		SetRwyColumn(hwndDlg, IDC_DRWY_AVAILABLE);
		SetRwyColumn(hwndDlg, IDC_DRWY_USED);
		SetRwyColumn(hwndDlg, IDC_ARWY_AVAILABLE);
		SetRwyColumn(hwndDlg, IDC_ARWY_USED);

		for (nItem = 0; nItem < FlpxHeader.m_DepartureAirport.m_nRwy; nItem++)
		{
			InsertRwyRow(hwndDlg, IDC_DRWY_USED, nItem, FlpxHeader.m_DepartureAirport.m_Rwy);
		}

		for (nItem = 0; nItem < FlpxHeader.m_ArrivalAirport.m_nRwy; nItem++)
		{
			InsertRwyRow(hwndDlg, IDC_ARWY_USED, nItem, FlpxHeader.m_ArrivalAirport.m_Rwy);
		}

		SetRwyColumnWidth(hwndDlg, IDC_DRWY_AVAILABLE);
		SetRwyColumnWidth(hwndDlg, IDC_DRWY_USED);
		SetRwyColumnWidth(hwndDlg, IDC_ARWY_AVAILABLE);
		SetRwyColumnWidth(hwndDlg, IDC_ARWY_USED);

		SendMessage(GetDlgItem(hwndDlg, IDC_AIRCRAFT_TYPE), CB_ADDSTRING, 0, (LPARAM)"Jet");
		SendMessage(GetDlgItem(hwndDlg, IDC_AIRCRAFT_TYPE), CB_ADDSTRING, 0, (LPARAM)"Turbo-Prop");
		SendMessage(GetDlgItem(hwndDlg, IDC_AIRCRAFT_TYPE), CB_ADDSTRING, 0, (LPARAM)"Prop");
		SendMessage(GetDlgItem(hwndDlg, IDC_AIRCRAFT_TYPE), CB_SETCURSEL, 0, 0);
		break;
	case WM_COMMAND:
		wNotifyCode = HIWORD(wParam);
		wID = LOWORD(wParam);
		hwndCtl = (HWND)lParam;

		if (hwndCtl != NULL && wNotifyCode == BN_CLICKED)
		{
			switch (wID)
			{
			case IDC_DRWY_ADD:
				MoveRwyRow(hwndDlg, IDC_DRWY_AVAILABLE, IDC_DRWY_USED, FlpxHeader.m_DepartureAirport.m_Rwy);
				return 1;
				break;
			case IDC_DRWY_DEL:
				MoveRwyRow(hwndDlg, IDC_DRWY_USED, IDC_DRWY_AVAILABLE, FlpxHeader.m_DepartureAirport.m_Rwy);
				return 1;
				break;
			case IDC_ARWY_ADD:
				MoveRwyRow(hwndDlg, IDC_ARWY_AVAILABLE, IDC_ARWY_USED, FlpxHeader.m_ArrivalAirport.m_Rwy);
				return 1;
				break;
			case IDC_ARWY_DEL:
				MoveRwyRow(hwndDlg, IDC_ARWY_USED, IDC_ARWY_AVAILABLE, FlpxHeader.m_ArrivalAirport.m_Rwy);
				return 1;
				break;
			case IDCANCEL:
				EndDialog(hwndDlg, IDCANCEL);
				return 1;
				break;
			case IDOK:
				GetWindowText(GetDlgItem(hwndDlg, IDC_TITLE), szTitle, sizeof(szTitle));
				for (nIndex = strlen(szTitle) - 1; nIndex >= 0 && szTitle[nIndex] == ' '; nIndex--)
					szTitle[nIndex] = '\0';

				GetWindowText(GetDlgItem(hwndDlg, IDC_DESCRIPTION), szDescr, sizeof(szDescr));
				for (nIndex = strlen(szDescr) - 1; nIndex >= 0 && szDescr[nIndex] == ' '; nIndex--)
					szDescr[nIndex] = '\0';

				if (szTitle[0] == '\0' || szDescr[0] == '\0')
					return 1;

				OnOK(hwndDlg, IDC_DRWY_USED, &FlpxHeader.m_DepartureAirport.m_nRwy, FlpxHeader.m_DepartureAirport.m_Rwy);
				OnOK(hwndDlg, IDC_ARWY_USED, &FlpxHeader.m_ArrivalAirport.m_nRwy, FlpxHeader.m_ArrivalAirport.m_Rwy);

				nAircraftType = 1 + SendMessage(GetDlgItem(hwndDlg, IDC_AIRCRAFT_TYPE), CB_GETCURSEL, 0, 0);

				EndDialog(hwndDlg, IDOK);
				return 1;
				break;
			}
		}
		break;
	case WM_NOTIFY:
		idCtrl = wParam;
		pnmh = (LPNMHDR)lParam;
		switch (pnmh->idFrom)
		{
		case IDC_DRWY_AVAILABLE:
			if (pnmh->code == LVN_ITEMCHANGED)
			{
				EnableWindow(GetDlgItem(hwndDlg, IDC_DRWY_ADD), SendMessage(pnmh->hwndFrom, LVM_GETSELECTEDCOUNT, 0, 0) > 0);
			}
			break;
		case IDC_DRWY_USED:
			if (pnmh->code == LVN_ITEMCHANGED)
			{
				EnableWindow(GetDlgItem(hwndDlg, IDC_DRWY_DEL), SendMessage(pnmh->hwndFrom, LVM_GETSELECTEDCOUNT, 0, 0) > 0);
			}
			break;
		case IDC_ARWY_AVAILABLE:
			if (pnmh->code == LVN_ITEMCHANGED)
			{
				EnableWindow(GetDlgItem(hwndDlg, IDC_ARWY_ADD), SendMessage(pnmh->hwndFrom, LVM_GETSELECTEDCOUNT, 0, 0) > 0);
			}
			break;
		case IDC_ARWY_USED:
			if (pnmh->code == LVN_ITEMCHANGED)
			{
				EnableWindow(GetDlgItem(hwndDlg, IDC_ARWY_DEL), SendMessage(pnmh->hwndFrom, LVM_GETSELECTEDCOUNT, 0, 0) > 0);
			}
			break;
		}
		break;
	}

	return 0;
}

BOOL Export2(const PVOID pFlightPlan, HWND hwndParent, FILE* pFile)
{
	FLPX_WAYPOINT WayPoint1 = { sizeof(FLPX_WAYPOINT) };
	FLPX_WAYPOINT WayPoint2 = { sizeof(FLPX_WAYPOINT) };
	int nCommand, nWayPoint;
	UINT uCheckpoint;

	nWayPoint = 0;
	uCheckpoint = 0;
	for (nCommand = FLPX_GETFIRST; FlpxGetWaypoint(pFlightPlan, nCommand, &WayPoint1); nCommand = FLPX_GETNEXT)
	{
		if (WayPoint1.m_cType == WPTYPE_IM || WayPoint1.m_cType == WPTYPE_MM || WayPoint1.m_cType == WPTYPE_OM ||
			WayPoint1.m_cType == WPTYPE_ATIS ||
			WayPoint1.m_cType == WPTYPE_BOC || WayPoint1.m_cType == WPTYPE_EOC ||
			WayPoint1.m_cType == WPTYPE_BOD || WayPoint1.m_cType == WPTYPE_EOD ||
			WayPoint1.m_cType == WPTYPE_EOCBOD || WayPoint1.m_cType == WPTYPE_EODBOC)
			continue;

		if (nWayPoint >= 2)
		{
			uCheckpoint++;

			if (fprintf(pFile, "%scheckpoint_%u_latitude = %0.6f\n", szLS, uCheckpoint, WayPoint2.m_fLat) < 0)
				return FALSE;
			if (fprintf(pFile, "%scheckpoint_%u_longitude = %0.6f\n", szLS, uCheckpoint, WayPoint2.m_fLon) < 0)
				return FALSE;
			if (fprintf(pFile, "%scheckpoint_%u_altitude = %0.0f\n", szLS, uCheckpoint, WayPoint2.m_fAlt) < 0)
				return FALSE;
			if (fprintf(pFile, "%scheckpoint_%u_speed = %0.0f\n", szLS, uCheckpoint, WayPoint2.m_fIAS) < 0)
				return FALSE;
			if (fprintf(pFile, "%scheckpoint_%u_freq = %0.2f\n", szLS, uCheckpoint, WayPoint2.m_fFreq) < 0)
				return FALSE;
			if (fprintf(pFile, "%scheckpoint_%u_heading = %0.0f\n", szLS, uCheckpoint, WayPoint2.m_fHead) < 0)
				return FALSE;
		}

		WayPoint2 = WayPoint1;
		nWayPoint++;
	}

	return TRUE;
}

BOOL Export1(const PVOID pFlightPlan, HWND hwndParent, FILE* pFile)
{
	int nIndex, nLen;
	LPCSTR lpcszTmp1;
	LPCSTR lpcszTmp2;
	char szTmp[100];

	if (fprintf(pFile, "ARRIVAL_ID = \"%s\"\n", FlpxHeader.m_ArrivalAirport.m_szId) < 0)
		return FALSE;
	if (fprintf(pFile, "; ALTERNATE_ID = \"%s\"\n", FlpxHeader.m_AlternateAirport.m_szId) < 0)
		return FALSE;
	if (fprintf(pFile, "HOLD_ID = \"%s\"\n", szHoldId) < 0)
		return FALSE;
	if (fprintf(pFile, "DEPARTURE_ID = \"%s\"\n", FlpxHeader.m_DepartureAirport.m_szId) < 0)
		return FALSE;
	if (fprintf(pFile, "; AIRCRAFT = \"%s\"\n", "") < 0)
		return FALSE;
	if (fprintf(pFile, "; CALLSIGN = \"%s\"\n\n", "") < 0)
		return FALSE;

	if (fprintf(pFile, "GET_FLIGHT_PLAN:\n") < 0)
		return FALSE;
	if (fprintf(pFile, "%sTitle \"%s\"\n", szLS, szTitle) < 0)
		return FALSE;

	for (lpcszTmp1 = szDescr; *lpcszTmp1; lpcszTmp1 += nLen)
	{
		nLen = 80;
		lpcszTmp2 = lpcszTmp1;

		do
		{
			if (*lpcszTmp2 == '\0' || *lpcszTmp2 == ' ')
				nLen = lpcszTmp2 - lpcszTmp1;
		}
		while (*lpcszTmp2 && lpcszTmp2++ - lpcszTmp1 < 80);

		if (fprintf(pFile, "%sDescription \"%.*s\"\n", szLS, nLen, lpcszTmp1) < 0)
			return FALSE;
	}

	if (fprintf(pFile, "\n") < 0)
		return FALSE;

	if (fprintf(pFile, "; %sforce_holding = 1\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "; %sflight_planner = 3\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "%saircraft_type = %d\n", szLS, nAircraftType) < 0)
		return FALSE;
	if (fprintf(pFile, "%sdeparture_elevation = %0.0f\n", szLS, FlpxHeader.m_DepartureAirport.m_fElevation) < 0)
		return FALSE;
	if (fprintf(pFile, "%sarrival_elevation = %0.0f\n", szLS, FlpxHeader.m_ArrivalAirport.m_fElevation) < 0)
		return FALSE;
	if (fprintf(pFile, "%sfiled_altitude = %0.0f\n", szLS, ceil(fCruiseAlt / 10)) < 0)
		return FALSE;

	if (fprintf(pFile, "%sdeparture_atis_freq = %0.0f\n", szLS,
						(FlpxHeader.m_DepartureAirport.m_fAtisFreq != 0.0 ? FlpxHeader.m_DepartureAirport.m_fAtisFreq : 135.40) * 100) < 0)
		return FALSE;
	if (fprintf(pFile, "%sarrival_atis_freq = %0.0f\n", szLS,
						(FlpxHeader.m_ArrivalAirport.m_fAtisFreq != 0.0 ? FlpxHeader.m_ArrivalAirport.m_fAtisFreq : 126.70) * 100) < 0)
		return FALSE;
	if (fprintf(pFile, "%sflight_services_freq = 12220\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "%sdelivery_freq = 12165\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "%sdeparture_ground_freq = 12190\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "%sdeparture_tower_freq = 11870\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "%sdeparture_freq = 11920\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "%scenter_freq = 11835\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "%sarrival_ground_freq = 12180\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "%sarrival_tower_freq = 11830\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "%sapproach_freq = 12485\n", szLS) < 0)
		return FALSE;

	if (fprintf(pFile, "; %stwofifty_altitude = 0\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "; %sradar_approach = 0\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "; %sradar_departure = 0\n", szLS) < 0)
		return FALSE;

	if (fprintf(pFile, "%sannounce_passing_checkpoint = 1\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "; %sdeparture_minimum_altitude = 300\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "; %sdeparture_maximum_altitude = 600\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "; %sarrival_minimum_altitude = 300\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "; %sarrival_maximum_altitude = 600\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "; %smissed_approach_altitude = 320\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "; %sheading_deviation = 15\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "; %saltitude_deviation = 200\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "; %sspeed_deviation = 15\n", szLS) < 0)
		return FALSE;

	if (fprintf(pFile, "%snumber_of_checkpoints = %u\n", szLS, nCheckpoints) < 0)
		return FALSE;

	if (fprintf(pFile, "%sdeparture_latitude = %0.6f\n", szLS, FlpxHeader.m_DepartureAirport.m_fLat) < 0)
		return FALSE;
	if (fprintf(pFile, "%sdeparture_longitude = %0.6f\n", szLS, FlpxHeader.m_DepartureAirport.m_fLon) < 0)
		return FALSE;
	if (fprintf(pFile, "; %sdeparture_speed = 0\n", szLS) < 0)
		return FALSE;

	if (fprintf(pFile, "; %salternate_latitude = 0\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "; %salternate_longitude = 0\n", szLS) < 0)
		return FALSE;
	if (fprintf(pFile, "; %salternate_elevation = 0\n", szLS) < 0)
		return FALSE;

	if (fprintf(pFile, "%sarrival_latitude = %0.6f\n", szLS, FlpxHeader.m_ArrivalAirport.m_fLat) < 0)
		return FALSE;
	if (fprintf(pFile, "%sarrival_longitude = %0.6f\n", szLS, FlpxHeader.m_ArrivalAirport.m_fLon) < 0)
		return FALSE;

	if (!Export2(pFlightPlan, hwndParent, pFile))
		return FALSE;

	for (nIndex = 0; nIndex < FlpxHeader.m_DepartureAirport.m_nRwy; nIndex++)
	{
		strcpy(szTmp, FlpxHeader.m_DepartureAirport.m_Rwy[nIndex].m_szId);
		nLen = strlen(szTmp);
		switch (szTmp[nLen - 1])
		{
		case 'L':
			szTmp[nLen - 1] = '1';
			break;
		case 'C':
			szTmp[nLen - 1] = '2';
			break;
		case 'R':
			szTmp[nLen - 1] = '3';
			break;
		default:
			strcat(szTmp, "0");
			break;
		}

		if (fprintf(pFile, "%sd_runway_%u_id = %s\n", szLS, nIndex + 1, szTmp) < 0)
			return FALSE;
		if (fprintf(pFile, "%sd_runway_%u_heading = %0.0f\n", szLS, nIndex + 1, FlpxHeader.m_DepartureAirport.m_Rwy[nIndex].m_fHead) < 0)
			return FALSE;
		if (fprintf(pFile, "%sd_runway_%u_latitude = %0.6f\n", szLS, nIndex + 1, FlpxHeader.m_DepartureAirport.m_Rwy[nIndex].m_fLat) < 0)
			return FALSE;
		if (fprintf(pFile, "%sd_runway_%u_longitude = %0.6f\n", szLS, nIndex + 1, FlpxHeader.m_DepartureAirport.m_Rwy[nIndex].m_fLon) < 0)
			return FALSE;
		if (fprintf(pFile, "%sd_runway_%u_altitude = %0.0f\n", szLS, nIndex + 1, FlpxHeader.m_DepartureAirport.m_Rwy[nIndex].m_fElevation) < 0)
			return FALSE;
	}

	for (nIndex = 0; nIndex < FlpxHeader.m_ArrivalAirport.m_nRwy; nIndex++)
	{
		strcpy(szTmp, FlpxHeader.m_ArrivalAirport.m_Rwy[nIndex].m_szId);
		nLen = strlen(szTmp);
		switch (szTmp[nLen - 1])
		{
		case 'L':
			szTmp[nLen - 1] = '1';
			break;
		case 'C':
			szTmp[nLen - 1] = '2';
			break;
		case 'R':
			szTmp[nLen - 1] = '3';
			break;
		default:
			strcat(szTmp, "0");
			break;
		}

		if (fprintf(pFile, "%sa_runway_%u_id = %s\n", szLS, nIndex + 1, szTmp) < 0)
			return FALSE;
		if (fprintf(pFile, "%sa_runway_%u_heading = %0.0f\n", szLS, nIndex + 1, FlpxHeader.m_ArrivalAirport.m_Rwy[nIndex].m_fHead) < 0)
			return FALSE;
		if (fprintf(pFile, "%sa_runway_%u_latitude = %0.6f\n", szLS, nIndex + 1, FlpxHeader.m_ArrivalAirport.m_Rwy[nIndex].m_fLat) < 0)
			return FALSE;
		if (fprintf(pFile, "%sa_runway_%u_longitude = %0.6f\n", szLS, nIndex + 1, FlpxHeader.m_ArrivalAirport.m_Rwy[nIndex].m_fLon) < 0)
			return FALSE;
		if (fprintf(pFile, "%sa_runway_%u_altitude = %0.0f\n", szLS, nIndex + 1, FlpxHeader.m_ArrivalAirport.m_Rwy[nIndex].m_fElevation) < 0)
			return FALSE;
		if (fprintf(pFile, "%sa_runway_%u_freq = %0.2f\n", szLS, nIndex + 1, FlpxHeader.m_ArrivalAirport.m_Rwy[nIndex].m_fFreq) < 0)
			return FALSE;
	}

	if (fprintf(pFile, "RETURN\n") < 0)
		return FALSE;

	return TRUE;
}

BOOL __stdcall Export(const PVOID pFlightPlan, HWND hwndParent)
{
	FILE*	pFile;
	char	szInitialDir[_MAX_PATH], szFileName[_MAX_PATH], szTmp[100];
	char*	pszTmp;
	FLPX_WAYPOINT WayPoint = { sizeof(FLPX_WAYPOINT) };
	int		nCommand;
	BOOL	bResult = TRUE;

	nCheckpoints = 0;
	fCruiseAlt = 0;
	for (nCommand = FLPX_GETLAST; FlpxGetWaypoint(pFlightPlan, nCommand, &WayPoint); nCommand = FLPX_GETPREV)
	{
		if (WayPoint.m_fAlt > fCruiseAlt)
			fCruiseAlt = WayPoint.m_fAlt;

		if (WayPoint.m_cType == WPTYPE_IM || WayPoint.m_cType == WPTYPE_MM || WayPoint.m_cType == WPTYPE_OM ||
			WayPoint.m_cType == WPTYPE_ATIS ||
			WayPoint.m_cType == WPTYPE_BOC || WayPoint.m_cType == WPTYPE_EOC ||
			WayPoint.m_cType == WPTYPE_BOD || WayPoint.m_cType == WPTYPE_EOD ||
			WayPoint.m_cType == WPTYPE_EOCBOD || WayPoint.m_cType == WPTYPE_EODBOC)
			continue;

		if (nCheckpoints == 1)
			strcpy(szHoldId, WayPoint.m_szId);

		nCheckpoints++;
	}

	if ((nCheckpoints -= 2) < 0)
		return FALSE;

	if (!FlpxGetHeader(pFlightPlan, &FlpxHeader) || !FlpxHeader.m_DepartureAirport.m_bValid || !FlpxHeader.m_ArrivalAirport.m_bValid)
		return FALSE;

	if (DialogBox(hThisModule, MAKEINTRESOURCE(IDD_OPTIONS), hwndParent, DialogProcOptions) != IDOK)
		return TRUE;

	GetPrivateProfileString(APP_NAME, INITIAL_DIR, "", szInitialDir, sizeof(szInitialDir), szIniFilePath);

	sprintf(szTmp, "%s Flight Plan (*.apl)|*.apl|All Files (*.*)|*.*||", APP_NAME);
	if (!FlpxDlgSaveAs(szFileName, hwndParent, szTmp, szInitialDir, "apl", NULL))
		return TRUE;

	strcpy(szInitialDir, szFileName);
	if (pszTmp = strrchr(szInitialDir, '\\'))
		*(pszTmp + 1) = '\0';
	WritePrivateProfileString(APP_NAME, INITIAL_DIR, szInitialDir, szIniFilePath);

	if ((pFile = fopen(szFileName, "wt")) == NULL)
		return FALSE;

	bResult = Export1(pFlightPlan, hwndParent, pFile);

	if (fclose(pFile) == EOF)
		bResult = FALSE;

	return bResult;
}

FLPX_IMPORT_TABLE FlpxImportTable =
{
	sizeof(FLPX_IMPORT_TABLE),
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};

FLPX_EXPORT_TABLE FlpxExportTable =
{
	sizeof(FLPX_EXPORT_TABLE),
	APP_NAME,
	NULL,
	Export
};

#ifdef __cplusplus
}
#endif
