// FileAll.h: Schnittstelle fr die Klasse CFileAll.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FILEALL_H__76368BC2_250A_11D1_A4AD_204C4F4F5020__INCLUDED_)
#define AFX_FILEALL_H__76368BC2_250A_11D1_A4AD_204C4F4F5020__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CFileAll : public CFile  
{
public:
	virtual BOOL	Open(LPCTSTR lpcszFileName, UINT nOpenFlags, CFileException* pFileException = NULL);
	virtual BOOL	Close(CFileException* pFileException = NULL);
	virtual UINT	Read(void* lpBuffer, UINT uBytesRead, CFileException* pFileException = NULL, \
										LONG lStructSize = 0, LONG lStruct = 0, LONG lOffset = 0);
	virtual BOOL	Write(const void* lpcBuffer, UINT uBytesWrite, CFileException* pFileException = NULL, \
										LONG lStructSize = 0, LONG lStruct = 0, LONG lOffset = 0);
	virtual	BOOL	Flush(CFileException* pFileException = NULL);
	virtual	DWORD	GetLength(CFileException* pFileException = NULL);

	static	BOOL	Rename(LPCTSTR lpcszOldName, LPCTSTR lpcszNewName, CFileException* pFileException = NULL);
	static	BOOL	Remove(LPCTSTR lpcszFileName, CFileException* pFileException = NULL);

	CFileAll(int hFile = CFile::hFileNull);
	virtual ~CFileAll();
};

#endif // !defined(AFX_FILEALL_H__76368BC2_250A_11D1_A4AD_204C4F4F5020__INCLUDED_)
