// FileAll.cpp: Implementierung der Klasse CFileAll.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "FileAll.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

CFileAll::CFileAll(int hFile)
:CFile(hFile)
{

}

CFileAll::~CFileAll()
{

}

/////////////////////////////////////////////////////////////////////////////

BOOL CFileAll::Open(LPCTSTR lpcszFileName, UINT nOpenFlags, CFileException* pFileException)
{
	CFileException	e;
	BOOL			fResult;

	fResult = CFile::Open(lpcszFileName, nOpenFlags, &e);

	if (pFileException)
	{
		pFileException->m_cause = e.m_cause;
		pFileException->m_lOsError = e.m_lOsError;
		pFileException->m_strFileName = e.m_strFileName;
	}

	return fResult;
}

BOOL CFileAll::Close(CFileException* pFileException)
{
	TRY
	{
		if (pFileException)
		{
			pFileException->m_cause = CFileException::none;
			pFileException->m_lOsError = 0;
			pFileException->m_strFileName.Empty();
		}

		if (m_hFile	== CFile::hFileNull)
			return TRUE;

		CFile::Close();

		return TRUE;
	}
	CATCH(CFileException, pe)
	{
		if (pFileException)
		{
			pFileException->m_cause = pe->m_cause;
			pFileException->m_lOsError = pe->m_lOsError;
			pFileException->m_strFileName = pe->m_strFileName;
		}

		return FALSE;
	}
	END_CATCH
}

//  Ist RetVal == 0 und pFileException->m_cause enthlt "CFileException::none", dann ist das Dateiende erreicht.
UINT CFileAll::Read(void* lpBuffer, UINT uBytesRead, CFileException* pFileException,
					LONG lStructSize, LONG lStruct, LONG lOffset)
{
	TRY
	{
		if (pFileException)
		{
			pFileException->m_cause = CFileException::none;
			pFileException->m_lOsError = 0;
			pFileException->m_strFileName.Empty();
		}

		if (m_hFile	== CFile::hFileNull)
			return 0;

		if (lStructSize != 0 || lOffset != 0)
			CFile::Seek(lOffset + lStruct * lStructSize, begin);

		return CFile::Read(lpBuffer, uBytesRead);
	}
	CATCH(CFileException, pe)
	{
		if (pFileException)
		{
			pFileException->m_cause = pe->m_cause;
			pFileException->m_lOsError = pe->m_lOsError;
			pFileException->m_strFileName = pe->m_strFileName;
		}

		return 0;
	}
	END_CATCH
}

BOOL CFileAll::Write(const void* lpcBuffer, UINT uBytesWrite, CFileException* pFileException,
					 LONG lStructSize, LONG lStruct, LONG lOffset)
{
	TRY
	{
		if (pFileException)
		{
			pFileException->m_cause = CFileException::none;
			pFileException->m_lOsError = 0;
			pFileException->m_strFileName.Empty();
		}

		if (m_hFile	== CFile::hFileNull)
			return TRUE;

		if (lStructSize != 0 || lOffset != 0)
	    	CFile::Seek(lOffset + lStruct * lStructSize, begin);

	    CFile::Write(lpcBuffer, uBytesWrite);

		return TRUE;
	}
	CATCH(CFileException, pe)
	{
		if (pFileException)
		{
			pFileException->m_cause = pe->m_cause;
			pFileException->m_lOsError = pe->m_lOsError;
			pFileException->m_strFileName = pe->m_strFileName;
		}

		return FALSE;
	}
	END_CATCH
}

BOOL CFileAll::Flush(CFileException* pFileException)
{
	TRY
	{
		CFile::Flush();

		if (pFileException)
		{
			pFileException->m_cause = CFileException::none;
			pFileException->m_lOsError = 0;
			pFileException->m_strFileName.Empty();
		}

		return TRUE;
	}
	CATCH(CFileException, pe)
	{
		if (pFileException)
		{
			pFileException->m_cause = pe->m_cause;
			pFileException->m_lOsError = pe->m_lOsError;
			pFileException->m_strFileName = pe->m_strFileName;
		}

		return FALSE;
	}
	END_CATCH
}

DWORD CFileAll::GetLength(CFileException* pFileException)
{
	TRY
	{
		return CFile::GetLength();
	}
	CATCH(CFileException, pe)
	{
		if (pFileException)
		{
			pFileException->m_cause = pe->m_cause;
			pFileException->m_lOsError = pe->m_lOsError;
			pFileException->m_strFileName = pe->m_strFileName;
		}

		return 0;
	}
	END_CATCH
}

BOOL CFileAll::Rename(LPCTSTR lpcszOldName, LPCTSTR lpcszNewName, CFileException* pFileException)
{
	TRY
	{
		CFile::Rename(lpcszOldName, lpcszNewName);

		if (pFileException)
		{
			pFileException->m_cause = CFileException::none;
			pFileException->m_lOsError = 0;
			pFileException->m_strFileName.Empty();
		}

		return TRUE;
	}
	CATCH(CFileException, pe)
	{
		if (pFileException)
		{
			pFileException->m_cause = pe->m_cause;
			pFileException->m_lOsError = pe->m_lOsError;
			pFileException->m_strFileName = pe->m_strFileName;
		}

		return FALSE;
	}
	END_CATCH
}

BOOL CFileAll::Remove(LPCTSTR lpcszFileName, CFileException* pFileException)
{
	TRY
	{
		CFile::Remove(lpcszFileName);

		if (pFileException)
		{
			pFileException->m_cause = CFileException::none;
			pFileException->m_lOsError = 0;
			pFileException->m_strFileName.Empty();
		}

		return TRUE;
	}
	CATCH(CFileException, pe)
	{
		if (pFileException)
		{
			pFileException->m_cause = pe->m_cause;
			pFileException->m_lOsError = pe->m_lOsError;
			pFileException->m_strFileName = pe->m_strFileName;
		}

		return FALSE;
	}
	END_CATCH
}
