///////////////////////////////////////////////////
// !!!Open source!!! Use the file at your own risk.
///////////////////////////////////////////////////

#ifdef __cplusplus
extern "C" {
#endif

#pragma pack(push, 1)
///////////////////////////////////////////////////

#define INI_FILE_NAME	"FlpExport.ini"

#define FLPX_GETFIRST	-2
#define FLPX_GETPREV	-1
#define FLPX_GETACT		0
#define FLPX_GETNEXT	1
#define FLPX_GETLAST	2

#define FUEL_MEASURE_LBS	0
#define FUEL_MEASURE_GAL	1
#define FUEL_MEASURE_KG		2
#define FUEL_MEASURE_L		3

#define WPTYPE_APT		'A'
#define WPTYPE_ATIS		'B'
#define WPTYPE_RWY		'C'
#define WPTYPE_IM		'D'
#define WPTYPE_MM		'E'
#define WPTYPE_OM		'F'
#define WPTYPE_ILS		'G'
#define WPTYPE_ILSGS	'H'
#define WPTYPE_VORTAC	'I'
#define WPTYPE_VORDME	'K'
#define WPTYPE_DME		'L'
#define WPTYPE_VOR		'M'
#define WPTYPE_NDB		'N'
#define WPTYPE_ISEC		'O'
#define WPTYPE_GPS		'P'
#define WPTYPE_TOC		'Q'
#define WPTYPE_BOD		'R'
#define WPTYPE_TOCBOD	'S'

#define FLPX_MAX_RWY	16

typedef struct FLPX_RUNWAY
{
	char	m_szId[6];
	double	m_fHead;
	double	m_fLat;
	double	m_fLon;
	double	m_fElevation;
	double	m_fLength;
	double	m_fWidth;
	double	m_fFreq;
}
FLPX_RUNWAY, *PFLPX_RUNWAY;

typedef struct FLPX_AIRPORT
{
	BOOL	m_bValid;
	char	m_szName[31];
	char	m_szId[6];
	double	m_fAtisFreq;
	double	m_fLat;
	double	m_fLon;
	double	m_fElevation;
	int		m_nReserved[4];
	int		m_nRwy;
	FLPX_RUNWAY m_Rwy[FLPX_MAX_RWY];
}
FLPX_AIRPORT, *PFLPX_AIRPORT;

typedef struct FLPX_HEADER
{
	DWORD			m_dwSize;				// sizeof(FLPX_HEADER)
	char			m_szAircraftName[31];
	BYTE			m_uFuelMeasure;			// unit of measurement
	int				m_nReserved[8];
	FLPX_AIRPORT	m_DepartureAirport;
	FLPX_AIRPORT	m_ArrivalAirport;
	FLPX_AIRPORT	m_AlternateAirport;		// not available
}
FLPX_HEADER, *PFLPX_HEADER;

typedef struct FLPX_WAYPOINT
{
	DWORD	m_dwSize;		// sizeof(FLPX_WAYPOINT)
	char	m_cType;		// WPTYPE_
	double	m_fLat;			// -90 ... 90
	double	m_fLon;			// -180 ... 180
	double	m_fHead;		// 0 ... 360
	double	m_fSpeed;		// TAS/IAS kts (dependent from the flight simulator option)
	double	m_fTAS;			// TAS kts
	double	m_fIAS;			// IAS kts
	double	m_fMach;		// not available
	double	m_fVSpeed;		// ft/min
	double	m_fAlt;			// ft
	double	m_fDist;		// nm
	double	m_fEte;			// min
	double	m_fFuel;		// unit of measurement defined from FLPX_HEADER::m_uFuelMeasure
	double	m_fFreq;		// frequency
	char	m_szId[6];
	char	m_szName[31];
}
FLPX_WAYPOINT, *PFLPX_WAYPOINT;

///////////////////////////////////////////////////

typedef BOOL __stdcall DLG_SAVE_AS_ROUTINE(char szPathName[_MAX_PATH], HWND hwndParent,
											const char* pcszFilter, const char* pcszInitialDir,
											const char* pcszDefExt, const char* pcszDefFileName);
typedef DLG_SAVE_AS_ROUTINE* PDLG_SAVE_AS_ROUTINE;

typedef BOOL __stdcall GET_HEADER_ROUTINE(const PVOID pFlightPlan, PFLPX_HEADER pFlpxHeader);
typedef GET_HEADER_ROUTINE* PGET_HEADER_ROUTINE;

typedef BOOL __stdcall GET_WAYPOINT_ROUTINE(const PVOID pFlightPlan, int nCommand, PFLPX_WAYPOINT pWayPoint);
typedef GET_WAYPOINT_ROUTINE* PGET_WAYPOINT_ROUTINE;

typedef struct FLPX_IMPORT_TABLE
{
	DWORD						m_dwSize;			// sizeof(FLPX_IMPORT_TABLE)
	PDLG_SAVE_AS_ROUTINE		DlgSaveAsRoutine;	// FSNavigator set this function pointer
	PGET_HEADER_ROUTINE			GetHeaderRoutine;	// FSNavigator set this function pointer
	PGET_WAYPOINT_ROUTINE		GetWaypointRoutine;	// FSNavigator set this function pointer
	PVOID						pReserved1;
	PVOID						pReserved2;
	PVOID						pReserved3;
	PVOID						pReserved4;
}
FLPX_IMPORT_TABLE, *PFLPX_IMPORT_TABLE;

///////////////////////////////////////////////////

typedef	void __stdcall OPTIONS_ROUTINE(const PVOID pFlightPlan, HWND hwndParent);
typedef	OPTIONS_ROUTINE* POPTIONS_ROUTINE;

typedef	BOOL __stdcall EXPORT_ROUTINE(const PVOID pFlightPlan, HWND hwndParent);
typedef	EXPORT_ROUTINE* PEXPORT_ROUTINE;

typedef struct FLPX_EXPORT_TABLE
{
	DWORD				m_dwSize;					// sizeof(FLPX_EXPORT_TABLE)
	const char*			m_pcszDescription;			// Description string for the Export dialog box
	POPTIONS_ROUTINE	OptionsRoutine;				// NULL or function pointer
	PEXPORT_ROUTINE		ExportRoutine;				// NULL or function pointer
}
FLPX_EXPORT_TABLE, *PFLPX_EXPORT_TABLE;

///////////////////////////////////////////////////

__declspec(dllexport) FLPX_IMPORT_TABLE FlpxImportTable;
__declspec(dllexport) FLPX_EXPORT_TABLE FlpxExportTable;

///////////////////////////////////////////////////

#define FlpxDlgSaveAs		(FlpxImportTable.DlgSaveAsRoutine)
#define FlpxGetHeader		(FlpxImportTable.GetHeaderRoutine)
#define FlpxGetWaypoint		(FlpxImportTable.GetWaypointRoutine)

///////////////////////////////////////////////////
#pragma pack(pop)

#ifdef __cplusplus
}
#endif
