// ScenViewUtil.cpp: Implementierung der Klasse CScenViewUtil.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "ScenViewUtil.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

CScenViewUtil::CScenViewUtil()
{
	m_bRoundWorld = false;
	SetZoom(1, 0, 0);
}

CScenViewUtil::~CScenViewUtil()
{

}

//////////////////////////////////////////////////////////////////////
// public

int CScenViewUtil::SetZoom(int nFaktor, double fCenterLat, double fCenterLon)
{
	if (nFaktor < 1)
		nFaktor = 1;
	else if (nFaktor > SYMBOL_ZOOM && nFaktor < 2 * SYMBOL_ZOOM && GetZoom() < SYMBOL_ZOOM)
		nFaktor = SYMBOL_ZOOM;
	else if (nFaktor > 9999)
		nFaktor = 9999;

	for (int nIndex = m_ZoomArray.GetUpperBound(); nIndex >= 0; nIndex--)
	{
		if (m_ZoomArray.ElementAt(nIndex).m_nFaktor >= nFaktor)
			m_ZoomArray.RemoveAt(nIndex);
	}

	m_ZoomArray.Add(CZoom(nFaktor, fCenterLat, fCenterLon));
	CalculateCenter();

	return nFaktor;
}

int CScenViewUtil::GetZoom()
{
	return m_ZoomArray.ElementAt(m_ZoomArray.GetUpperBound()).m_nFaktor;
}

int CScenViewUtil::ZoomOut()
{
	if (m_ZoomArray.GetSize() > 1)
	{
		m_ZoomArray.RemoveAt(m_ZoomArray.GetUpperBound());
		CalculateCenter();
	}

	return m_ZoomArray.ElementAt(m_ZoomArray.GetUpperBound()).m_nFaktor;
}

void CScenViewUtil::SetCenter(double fCenterLat, double fCenterLon, bool bAll)
{
	for (int nIndex = bAll ? 0 : m_ZoomArray.GetUpperBound(); nIndex < m_ZoomArray.GetSize(); nIndex++)
	{
		CZoom&	Zoom = m_ZoomArray.ElementAt(nIndex);

		Zoom.m_fCenterLat = fCenterLat;
		Zoom.m_fCenterLon = fCenterLon;
	}

	CalculateCenter();
}

// calculates the visible Lat/Lon area from the screen size
void CScenViewUtil::GetViewArea(int nViewWidth, int nViewHeight, double& fLatMin, double& fLatMax, double& fLonMin, double& fLonMax)
{
	if (!GetRoundWorld())
	{	// flat world
		double fTmp;

		if (!ScreenToGlob(fTmp, fLonMin, 0, nViewHeight / 2, nViewWidth, nViewHeight))
			fLonMin = -180.0;

		if (!ScreenToGlob(fTmp, fLonMax, nViewWidth, nViewHeight / 2, nViewWidth, nViewHeight))
			fLonMax = 180.0;

		if (!ScreenToGlob(fLatMin, fTmp, nViewWidth / 2, nViewHeight, nViewWidth, nViewHeight))
			fLatMin = -90.0;

		if (!ScreenToGlob(fLatMax, fTmp, nViewWidth / 2, 0, nViewWidth, nViewHeight))
			fLatMax = 90.0;
	}
	else
	{	// round world
		double	fLatTopLeft, fLonTopLeft;
		double	fLatTopRight, fLonTopRight;
		double	fLatBottomRight, fLonBottomRight;
		double	fLatBottomLeft, fLonBottomLeft;
		long	xc, yc;

		if (!ScreenToGlob(fLatTopLeft, fLonTopLeft, 0, 0, nViewWidth, nViewHeight) ||
			!ScreenToGlob(fLatTopRight, fLonTopRight, nViewWidth, 0, nViewWidth, nViewHeight) ||
			!ScreenToGlob(fLatBottomRight, fLonBottomRight, nViewWidth, nViewHeight, nViewWidth, nViewHeight) ||
			!ScreenToGlob(fLatBottomLeft, fLonBottomLeft, 0, nViewHeight, nViewWidth, nViewHeight))
		{	// die Kugel fllt nicht das Bild
			fLonMin = fLonMax = 0.0;
			fLatMin = GetCenterLat() - 90.0;
			if (fLatMin < -90.0)
				fLatMin = -90.0;
			fLatMax = GetCenterLat() + 90.0;
			if (fLatMax > 90.0)
				fLatMax = 90.0;
		}
		else if (GlobToScreen(xc, yc, 90.0, 0, nViewWidth, nViewHeight))
		{	// nordpool visible
			fLonMin = fLonMax = 0.0;
			fLatMin = min(min(min(fLatTopLeft, fLatTopRight), fLatBottomRight), fLatBottomLeft);
			fLatMax = 90.0;
		}
		else if (GlobToScreen(xc, yc, -90.0, 0, nViewWidth, nViewHeight))
		{	// sdpool visible
			fLonMin = fLonMax = 0.0;
			fLatMin = -90.0;
			fLatMax = max(max(max(fLatTopLeft, fLatTopRight), fLatBottomRight), fLatBottomLeft);
		}
		else
		{	// kein Pool visible
			double fLonTmp;
			ScreenToGlob(fLatMax, fLonTmp, nViewWidth / 2, 0, nViewWidth, nViewHeight);
			ScreenToGlob(fLatMin, fLonTmp, nViewWidth / 2, nViewHeight, nViewWidth, nViewHeight);
			fLatMax	= max(fLatMax, max(fLatTopLeft, fLatTopRight));
			fLatMin = min(fLatMin, min(fLatBottomLeft, fLatBottomRight));

			if (GetCenterLat() >= 0)
			{
				fLonMin = fLonTopLeft;
				fLonMax	= fLonTopRight;
			}
			else
			{
				fLonMin = fLonBottomLeft;
				fLonMax	= fLonBottomRight;
			}
		}
	}

	TRACE("LatMin: %.2f, LatMax: %.2f, LonMin: %.2f, LonMax: %.2f\n", fLatMin, fLatMax, fLonMin, fLonMax);
}

//////////////////////////////////////////////////////////////////////
// private

// calculates constant values for GlobToScreen and ScreenToGlob
void CScenViewUtil::CalculateCenter()
{
	CZoom&	Zoom = m_ZoomArray.ElementAt(m_ZoomArray.GetUpperBound());

	m_fSinLatCenter = sin(-Zoom.m_fCenterLat * fDegToRad);
	m_fCosLatCenter = cos(-Zoom.m_fCenterLat * fDegToRad);
	m_fSinLonCenter = sin(-Zoom.m_fCenterLon * fDegToRad);
	m_fCosLonCenter = cos(-Zoom.m_fCenterLon * fDegToRad);
}
