// ArrayUndo.h: Schnittstelle fr die Klasse CArrayUndo.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ARRAYUNDO_H__47443BA1_2239_11D2_A4B6_4854E82880EF__INCLUDED_)
#define AFX_ARRAYUNDO_H__47443BA1_2239_11D2_A4B6_4854E82880EF__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

template<class TYPE, class ARG_TYPE>
class CArrayUndo
{
public:
	CArrayUndo(int nMaxLevel = 100);
	virtual void	RemoveAll();
	virtual void	Push(ARG_TYPE Data);
	virtual bool	Undo();
	virtual bool	Redo();
	virtual TYPE&	Element() { return m_DataArray.ElementAt(m_nActLevel); }
	virtual bool	IsUndoValid() { return m_nActLevel > 0; }
	virtual bool	IsRedoValid() { return m_nActLevel < m_DataArray.GetUpperBound(); }
	virtual UINT	GetIdent() { return m_uIdentCtr; }
private:
	int		m_nMaxLevel;
	int		m_nActLevel;
	UINT	m_uIdentCtr;
	CArray<TYPE, ARG_TYPE>	m_DataArray;
	CArray<bool, bool>		m_ModifiedArray;
};

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

template<class TYPE, class ARG_TYPE>
CArrayUndo<TYPE, ARG_TYPE>::CArrayUndo(int nMaxLevel)
{
	m_nMaxLevel = nMaxLevel;
	RemoveAll();
	m_uIdentCtr = 0;
}

//////////////////////////////////////////////////////////////////////

template<class TYPE, class ARG_TYPE>
void CArrayUndo<TYPE, ARG_TYPE>::RemoveAll()
{
	m_DataArray.RemoveAll();
	m_ModifiedArray.RemoveAll();
	m_nActLevel = -1;
	m_uIdentCtr++;
}

template<class TYPE, class ARG_TYPE>
void CArrayUndo<TYPE, ARG_TYPE>::Push(ARG_TYPE Data)
{
	if (++m_nActLevel < m_DataArray.GetSize())
	{
		m_DataArray.RemoveAt(m_nActLevel, m_DataArray.GetSize() - m_nActLevel);
		m_ModifiedArray.RemoveAt(m_nActLevel, m_ModifiedArray.GetSize() - m_nActLevel);
	}

	if (m_DataArray.GetSize() == m_nMaxLevel)
	{
		m_DataArray.RemoveAt(0);
		m_ModifiedArray.RemoveAt(0);
		m_nActLevel--;
	}

	m_DataArray.Add(Data);
	m_ModifiedArray.Add(m_ModifiedArray.GetSize() != 0);
	m_uIdentCtr++;
}

template<class TYPE, class ARG_TYPE>
bool CArrayUndo<TYPE, ARG_TYPE>::Undo()
{
	if (IsUndoValid())
	{
		m_nActLevel--;
		m_uIdentCtr++;
	}

	return m_ModifiedArray.GetAt(m_nActLevel);
}

template<class TYPE, class ARG_TYPE>
bool CArrayUndo<TYPE, ARG_TYPE>::Redo()
{
	if (IsRedoValid())
	{
		m_nActLevel++;
		m_uIdentCtr++;
	}

	return m_ModifiedArray.GetAt(m_nActLevel);
}

#endif // !defined(AFX_ARRAYUNDO_H__47443BA1_2239_11D2_A4B6_4854E82880EF__INCLUDED_)
