// FixDlg.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include "FSNavFix.h"

#include "FixDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg-Dialogfeld fr Anwendungsbefehl "Info"

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialogfelddaten
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CString	m_strEMail;
	CString	m_strHomepage;
	//}}AFX_DATA

	// Vom Klassenassistenten generierte berladungen virtueller Funktionen
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	//}}AFX_VIRTUAL

// Implementierung
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	m_strEMail = _T("H_Schroeder@PowerOnline.net");
	m_strHomepage = _T("http://members.xoom.com/fstools/");
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Text(pDX, IDC_ABOUT_EMAIL, m_strEMail);
	DDX_Text(pDX, IDC_ABOUT_HOMEPAGE, m_strHomepage);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// Keine Nachrichten-Handler
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFixDlg Dialogfeld

CFixDlg::CFixDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFixDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFixDlg)
	m_strBglDirectory = _T("");
	m_strTextPath = _T("");
	m_strHelp = _T("");
	//}}AFX_DATA_INIT
	// Beachten Sie, dass LoadIcon unter Win32 keinen nachfolgenden DestroyIcon-Aufruf bentigt
	m_hIconMin = (HICON)LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDR_MAINFRAME), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	m_hIconMax = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CFixDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFixDlg)
	DDX_Control(pDX, IDC_FIX_MESSAGE, m_lbcMessage);
	DDX_Text(pDX, IDC_FIX_DIR, m_strBglDirectory);
	DDX_Text(pDX, IDC_FIX_PATH, m_strTextPath);
	DDX_Text(pDX, IDC_FIX_HELP, m_strHelp);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFixDlg, CDialog)
	//{{AFX_MSG_MAP(CFixDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_FIX_DIRBROWSE, OnFixDirbrowse)
	ON_BN_CLICKED(IDC_FIX_PATHBROWSE, OnFixPathbrowse)
	ON_BN_CLICKED(IDC_FIX_TOBGL, OnFixTobgl)
	ON_BN_CLICKED(IDC_FIX_TOTEXT, OnFixTotext)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFixDlg Nachrichten-Handler

void CFixDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// Wollen Sie Ihrem Dialogfeld eine Schaltflche "Minimieren" hinzufgen, bentigen Sie 
//  den nachstehenden Code, um das Symbol zu zeichnen. Fr MFC-Anwendungen, die das 
//  Dokument/Ansicht-Modell verwenden, wird dies automatisch fr Sie erledigt.

void CFixDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // Gertekontext fr Zeichnen

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Symbol in Client-Rechteck zentrieren
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Symbol zeichnen
		dc.DrawIcon(x, y, m_hIconMax);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// Die Systemaufrufe fragen den Cursorform ab, die angezeigt werden soll, whrend der Benutzer
//  das zum Symbol verkleinerte Fenster mit der Maus zieht.
HCURSOR CFixDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIconMax;
}

BOOL CFixDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Hinzufgen des Menbefehls "Info..." zum Systemmen.

	// IDM_ABOUTBOX muss sich im Bereich der Systembefehle befinden.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Symbol fr dieses Dialogfeld festlegen. Wird automatisch erledigt
	//  wenn das Hauptfenster der Anwendung kein Dialogfeld ist
	SetIcon(m_hIconMax, TRUE);		// Groes Symbol verwenden
	SetIcon(m_hIconMin, FALSE);		// Kleines Symbol verwenden
	
	// ZU ERLEDIGEN: Hier zustzliche Initialisierung einfgen
	m_lbcMessage.SetHorizontalExtent(850);

	m_strTextPath = AfxGetApp()->GetProfileString(SECTION_SETTINGS, ENTRY_TEXTPATH);
	m_strBglDirectory = AfxGetApp()->GetProfileString(SECTION_SETTINGS, ENTRY_BGLDIR);
	CString strTmp;
	m_strHelp.LoadString(IDS_HELP1);
	strTmp.LoadString(IDS_HELP2);
	m_strHelp += strTmp;
	strTmp.LoadString(IDS_HELP3);
	m_strHelp += strTmp;
	UpdateData(FALSE);
	
	return TRUE;  // Geben Sie TRUE zurck, auer ein Steuerelement soll den Fokus erhalten
}

void CFixDlg::OnCancel() 
{
	// TODO: Zustzlichen Bereinigungscode hier einfgen
	UpdateData(TRUE);
	AfxGetApp()->WriteProfileString(SECTION_SETTINGS, ENTRY_TEXTPATH, m_strTextPath);
	AfxGetApp()->WriteProfileString(SECTION_SETTINGS, ENTRY_BGLDIR, m_strBglDirectory);
	
	CDialog::OnCancel();
}

void CFixDlg::OnFixPathbrowse() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	CString	strFilter, strFile;

	strFilter += _T("Text Files (.txt)");
	strFilter += _T('\0');
	strFilter += _T("*.txt");
	strFilter += _T('\0');
	strFilter += _T("All Files (*.*)");
	strFilter += _T('\0');
	strFilter += _T("*.*");
	strFilter += _T('\0');

	OPENFILENAME ofn;
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = GetSafeHwnd();
	ofn.hInstance = NULL;
	ofn.lpstrFilter = strFilter;
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter = 0;
	ofn.nFilterIndex = 0;
	ofn.lpstrFile = strFile.GetBuffer(_MAX_PATH);
	ofn.nMaxFile = _MAX_PATH;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrTitle = _T("Text File");
	ofn.Flags = OFN_EXTENSIONDIFFERENT | OFN_HIDEREADONLY | OFN_NOTESTFILECREATE;
	ofn.nFileOffset = 0;
	ofn.nFileExtension = 0;
	ofn.lpstrDefExt = NULL;
	ofn.lCustData = 0;
	ofn.lpfnHook = NULL;
	ofn.lpTemplateName = NULL;

	BOOL bResult = ::GetOpenFileName(&ofn);
	strFile.ReleaseBuffer();

	if (!bResult)
		return;

	m_strTextPath  = strFile;
	UpdateData(FALSE);
}

void CFixDlg::OnFixDirbrowse() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	LPMALLOC	pMalloc;

	if (::SHGetMalloc(&pMalloc) == NOERROR)		// Gets the Shell's default allocator
	{
		CString			strTmp;
		BROWSEINFO		bi;
		char			szBuffer[MAX_PATH];
		LPITEMIDLIST	pidl;

		strTmp.LoadString(IDS_SELECT_BGLDIR);
		bi.hwndOwner = GetSafeHwnd();
		bi.pidlRoot = NULL;
		bi.pszDisplayName = szBuffer;
		bi.lpszTitle = strTmp;
		bi.ulFlags = BIF_RETURNFSANCESTORS | BIF_RETURNONLYFSDIRS;
		bi.lpfn = NULL;
		bi.lParam = 0;

		if ((pidl = ::SHBrowseForFolder(&bi)) != NULL)
		{
			if (::SHGetPathFromIDList(pidl, szBuffer))
			{ 
				m_strBglDirectory = szBuffer;
				UpdateData(FALSE);
			}

			pMalloc->Free(pidl);
		}

		pMalloc->Release();
	}
}

void CFixDlg::OnFixTobgl() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	CWaitCursor WaitCursor;
	UpdateData(TRUE);
	m_lbcMessage.ResetContent();

	OnFixTobgl1();

	AfxMessageBox(IDS_CONVERSION_END);
}

void CFixDlg::OnFixTobgl1() 
{
	CString strTmp;
	strTmp.LoadString(IDS_CONVERT);
	strTmp += _T(' ');
	strTmp += m_strTextPath;
	int nSelect = m_lbcMessage.AddString(strTmp);
	m_lbcMessage.SetCurSel(nSelect);
	m_lbcMessage.UpdateWindow();

	CStdioFile FileText;
	CFileException FileException;

	if (!FileText.Open(m_strTextPath, CFile::modeRead | CFile::shareDenyWrite | CFile::typeText, &FileException))
	{
		CString strTmp;
		BOOL bResult = FileException.GetErrorMessage(strTmp.GetBuffer(256), 256);
		strTmp.ReleaseBuffer();

		if (bResult)
		{
			int nSelect = m_lbcMessage.AddString(strTmp);
			m_lbcMessage.SetCurSel(nSelect);
			m_lbcMessage.UpdateWindow();
		}

		return;
	}

	CFileAll FileBgl[12][12];
	UINT uNdb[12][12];
	memset(uNdb, 0, sizeof(uNdb));

	if (OnFixTobgl2(FileBgl, FileException))
	{
		TRY
		{
			CString strLine;
			for (UINT uLine = 1; FileText.ReadString(strLine); uLine++)
			{
				LPTSTR lpszToken1 = _tcstok(strLine.LockBuffer(), _T("\t"));
				strLine.UnlockBuffer();
				if (lpszToken1 == NULL || *lpszToken1 == _T(';'))
					continue;

				LPTSTR lpszToken2 = _tcstok(NULL, _T("\t"));
				LPTSTR lpszToken3 = _tcstok(NULL, _T("\t"));
				LPTSTR lpszToken4 = _tcstok(NULL, _T("\t"));
				if (lpszToken2 == NULL || lpszToken3 == NULL || lpszToken4 == NULL)
				{
					CString strTmp1;
					strTmp1.LoadString(IDS_LINEERR);
					strTmp.Format(strTmp1, uLine, strLine);
					int nSelect = m_lbcMessage.AddString(strTmp);
					m_lbcMessage.SetCurSel(nSelect);
					m_lbcMessage.UpdateWindow();
					continue;
				}

				double fLat	= _tcstod(lpszToken1, NULL);
				double fLon	= _tcstod(lpszToken2, NULL);

				if (fLon < 0)
					fLon += 360;

				char szId[5];
				memset(szId, ' ', sizeof(szId));
				memcpy(szId, lpszToken3, min(strlen(lpszToken3), sizeof(szId)));

				char szName[24];
				memset(szName, ' ', sizeof(szName));
				memcpy(szName, lpszToken4, min(strlen(lpszToken4), sizeof(szName)));

				if (!OnFixTobgl3(uNdb, FileBgl, FileException, fLat, fLon, szId, szName))
				{
					CString strTmp;
					BOOL bResult = FileException.GetErrorMessage(strTmp.GetBuffer(256), 256);
					strTmp.ReleaseBuffer();

					if (bResult)
					{
						int nSelect = m_lbcMessage.AddString(strTmp);
						m_lbcMessage.SetCurSel(nSelect);
						m_lbcMessage.UpdateWindow();
					}

					break;
				}
			}
		}
		CATCH(CFileException, pe)
		{
			CString strTmp;
			BOOL bResult = FileException.GetErrorMessage(strTmp.GetBuffer(256), 256);
			strTmp.ReleaseBuffer();

			if (bResult)
			{
				int nSelect = m_lbcMessage.AddString(strTmp);
				m_lbcMessage.SetCurSel(nSelect);
				m_lbcMessage.UpdateWindow();
			}
		}
		END_CATCH
	}
	else
	{
		CString strTmp;
		BOOL bResult = FileException.GetErrorMessage(strTmp.GetBuffer(256), 256);
		strTmp.ReleaseBuffer();

		if (bResult)
		{
			int nSelect = m_lbcMessage.AddString(strTmp);
			m_lbcMessage.SetCurSel(nSelect);
			m_lbcMessage.UpdateWindow();
		}
	}

	for (int y = 0; y < 12; y++)
	{
		for (int x = 0; x < 12; x++)
		{
			BYTE bByte = 0;
			FileBgl[y][x].Write(&bByte, sizeof(bByte));

			CString strFilePath = FileBgl[y][x].GetFilePath();

			if (FileBgl[y][x].Close(&FileException))
			{
				strTmp.LoadString(IDS_INTERSECTIONS_WITH);
				CString strTmp1;
				strTmp1.Format(strTmp, uNdb[y][x]);
				strTmp.Format("fix_y%cx%c.bgl %s", _T('a') + y, _T('a') + x, strTmp1);
				int nSelect = m_lbcMessage.AddString(strTmp);
				m_lbcMessage.SetCurSel(nSelect);
				m_lbcMessage.UpdateWindow();
			}
			else
			{
				CString strTmp;
				BOOL bResult = FileException.GetErrorMessage(strTmp.GetBuffer(256), 256);
				strTmp.ReleaseBuffer();

				if (bResult)
				{
					int nSelect = m_lbcMessage.AddString(strTmp);
					m_lbcMessage.SetCurSel(nSelect);
					m_lbcMessage.UpdateWindow();
				}
			}

			if (uNdb[y][x] == 0)
				CFileAll::Remove(strFilePath);
		}
	}

	TRY
	{
		FileText.Close();
	}
	CATCH(CFileException, pe)
	{
		CString strTmp;
		BOOL bResult = FileException.GetErrorMessage(strTmp.GetBuffer(256), 256);
		strTmp.ReleaseBuffer();

		if (bResult)
		{
			int nSelect = m_lbcMessage.AddString(strTmp);
			m_lbcMessage.SetCurSel(nSelect);
			m_lbcMessage.UpdateWindow();
		}
	}
	END_CATCH
}

bool CFixDlg::OnFixTobgl2(CFileAll FileBgl[12][12], CFileException& FileException) 
{
	CString strBglPath;

	if (m_strBglDirectory.Right(1) == _T('\\'))
		strBglPath = m_strBglDirectory;
	else
		strBglPath = m_strBglDirectory + _T("\\");

	for (int y = 0; y < 12; y++)
	{
		for (int x = 0; x < 12; x++)
		{
			CString strName;
			strName.Format("fix_y%cx%c.bgl", _T('a') + y, _T('a') + x);

			if (!FileBgl[y][x].Open(strBglPath + strName, CFile::modeCreate | CFile::modeWrite | CFile::shareDenyWrite, &FileException))
				return false;

			WORD	wWord;
			DWORD	dwDWord;

			wWord = 99;//3;
			if (!FileBgl[y][x].Write(&wWord, sizeof(wWord), &FileException))
				return false;

			dwDWord = (DWORD)floor((y * 15 - 90 + 15) * fDegToMeters + .5);
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// Lat max
				return false;

			dwDWord = (DWORD)floor((y * 15 - 90) * fDegToMeters + .5);
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// Lat min
				return false;

			dwDWord = (DWORD)floor(((double)(x * 30 + 30)) * 4294967296.0 / 360.0 + .5);
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// Lon max
				return false;

			dwDWord = (DWORD)floor(((double)(x * 30)) * 4294967296.0 / 360.0 + .5);
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// Lon min
				return false;

			wWord = 0;
			dwDWord = 0;
			DWORD dwAdf = 0x80;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// VOR
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// Frequenz
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// SYNTH_SEEDS_08
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// SYNTH_SEEDS_09
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// SYNTH_SEEDS_10
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// SYNTH_SEEDS_11
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// SYNTH_SEEDS_12
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// SYNTH_SEEDS_13
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// SYNTH_SEEDS_14
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// SYNTH_SEEDS_15
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// OBJECT_DATA
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// LIBRARY_DATA
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// FACILITIES_DATA
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// ANCHOR POINT DATA
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// COM RADIO DATA
				return false;
			if (!FileBgl[y][x].Write(&dwAdf, sizeof(dwAdf), &FileException))		// ADF DATA
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// DYNAMIC OBJECT PATHS
				return false;
			if (!FileBgl[y][x].Write(&wWord, sizeof(wWord), &FileException))		// Library id min
				return false;
			if (!FileBgl[y][x].Write(&wWord, sizeof(wWord), &FileException))		// Library id min
				return false;
			if (!FileBgl[y][x].Write(&wWord, sizeof(wWord), &FileException))		// Library id min
				return false;
			if (!FileBgl[y][x].Write(&wWord, sizeof(wWord), &FileException))		// Library id min
				return false;
			if (!FileBgl[y][x].Write(&wWord, sizeof(wWord), &FileException))		// Library id max
				return false;
			if (!FileBgl[y][x].Write(&wWord, sizeof(wWord), &FileException))		// Library id max
				return false;
			if (!FileBgl[y][x].Write(&wWord, sizeof(wWord), &FileException))		// Library id max
				return false;
			if (!FileBgl[y][x].Write(&wWord, sizeof(wWord), &FileException))		// Library id max
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// MISC_DATA (iom, landme)
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// TITLE AND DESCRIPTION DATA
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// MAGVAR MAP PTR
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// EXCEPTION LIST PTR
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// 118
				return false;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// 122
				return false;
			if (!FileBgl[y][x].Write(&wWord, sizeof(wWord), &FileException))		// 126
				return false;

			BYTE bByte = 0x15;
			if (!FileBgl[y][x].Write(&bByte, sizeof(bByte), &FileException))		// 128
				return false;

			wWord = (WORD)floor(((y * 15 - 90) * fDegToMeters) / 512 + .5);
			if (!FileBgl[y][x].Write(&wWord, sizeof(wWord), &FileException))		// 129 LatMin
				return false;

			wWord = (WORD)floor(((y * 15 - 90 + 15) * fDegToMeters) / 512 + .5);
			if (!FileBgl[y][x].Write(&wWord, sizeof(wWord), &FileException))		// 131 LatMax
				return false;

			dwDWord = 138 - 128;
			if (!FileBgl[y][x].Write(&dwDWord, sizeof(dwDWord), &FileException))	// 133 Offset
				return false;

			bByte = 0x00;
			if (!FileBgl[y][x].Write(&bByte, sizeof(bByte), &FileException))		// 137 Stop
				return false;
		}
	}

	return true;
}

bool CFixDlg::OnFixTobgl3(UINT uNdb[12][12], CFileAll FileBgl[12][12], CFileException& FileException, double fLat, double fLon, char szId[5], char szName[24]) 
{
	int y = (int)((fLat + 90) / 15);
	if (y >= 12)
		y = 11;
	int x = (int)((fLon) / 30);
	if (x >= 12)
		x = 0;

	BYTE bByte = 0x04;
	if (!FileBgl[y][x].Write(&bByte, sizeof(bByte), &FileException))
		return false;

	WORD wWord = 0;
	if (!FileBgl[y][x].Write(&wWord, sizeof(wWord), &FileException))	// freq
		return false;

	bByte = 0;
	if (!FileBgl[y][x].Write(&bByte, sizeof(bByte), &FileException))	// ext_freq
		return false;

	int nLat = (int)floor(fLat / 90 * 5000875.0 + .5);
	if (!FileBgl[y][x].Write(&nLat, 3, &FileException))					// Lat
		return false;

	int nLon = (int)floor(fLon / 360 * 0x1000000 + .5);
	if (!FileBgl[y][x].Write(&nLon, 3, &FileException))					// Lon
		return false;

	wWord = 0;
	if (!FileBgl[y][x].Write(&wWord, sizeof(wWord), &FileException))	// Alt
		return false;

	bByte = 0x50;
	if (!FileBgl[y][x].Write(&bByte, sizeof(bByte), &FileException))	// Range
		return false;

	if (!FileBgl[y][x].Write(szId, 5, &FileException))					// Id
		return false;

	if (!FileBgl[y][x].Write(szName, 24, &FileException))				// Name
		return false;

	uNdb[y][x]++;

	return true;
}

void CFixDlg::OnFixTotext() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	CWaitCursor WaitCursor;
	UpdateData(TRUE);
	m_lbcMessage.ResetContent();

	OnFixTotext1();

	AfxMessageBox(IDS_CONVERSION_END);
}

void CFixDlg::OnFixTotext1()
{
	CFileFind FF;
	BOOL bFound;
	CString strBglPath;
	CStringArray ArrayBgl;

	if (m_strBglDirectory.Right(1) == _T('\\'))
		strBglPath = m_strBglDirectory + _T("*.bgl");
	else
		strBglPath = m_strBglDirectory + _T("\\*.bgl");

	if (bFound = FF.FindFile(strBglPath))
	{
		do
		{
			bFound = FF.FindNextFile();

			if (FF.IsDirectory())
				continue;

			for (int nIndex = ArrayBgl.GetUpperBound(); nIndex >= 0; nIndex--)
			{
				if (FF.GetFilePath().CompareNoCase(ArrayBgl.ElementAt(nIndex)) > 0)
					break;
			}

			ArrayBgl.InsertAt(nIndex + 1, FF.GetFilePath());
		}
		while (bFound);

		FF.Close();
	}

	if (ArrayBgl.GetSize() == 0)
	{
		CString strTmp;
		strTmp.LoadString(IDS_NO_BGL_FOUND);
		int nSelect = m_lbcMessage.AddString(strTmp);
		m_lbcMessage.SetCurSel(nSelect);
		m_lbcMessage.UpdateWindow();
		return;
	}

	CStdioFile FileText;
	CFileException FileException;

	if (!FileText.Open(m_strTextPath, CFile::modeCreate | CFile::modeWrite | CFile::shareDenyWrite | CFile::typeText, &FileException))
	{
		CString strTmp;
		BOOL bResult = FileException.GetErrorMessage(strTmp.GetBuffer(256), 256);
		strTmp.ReleaseBuffer();

		if (bResult)
		{
			int nSelect = m_lbcMessage.AddString(strTmp);
			m_lbcMessage.SetCurSel(nSelect);
			m_lbcMessage.UpdateWindow();
		}

		return;
	}

	bool bResult = true;
	for (int nIndex = 0; bResult && nIndex < ArrayBgl.GetSize(); nIndex++)
	{
		CString strTmp;
		strTmp.LoadString(IDS_CONVERT);
		strTmp += _T(' ');
		strTmp += ArrayBgl.ElementAt(nIndex);
		int nSelect = m_lbcMessage.AddString(strTmp);
		m_lbcMessage.SetCurSel(nSelect);
		m_lbcMessage.UpdateWindow();

		CFileAll FileBgl;

		if (!FileBgl.Open(ArrayBgl.ElementAt(nIndex), CFile::modeRead | CFile::shareDenyWrite, &FileException))
		{
			CString strTmp;
			BOOL bResult = FileException.GetErrorMessage(strTmp.GetBuffer(256), 256);
			strTmp.ReleaseBuffer();

			if (bResult)
			{
				int nSelect = m_lbcMessage.AddString(strTmp);
				m_lbcMessage.SetCurSel(nSelect);
				m_lbcMessage.UpdateWindow();
			}

			continue;
		}

		DWORD dwBglSize	= FileBgl.GetLength(&FileException);
		if (dwBglSize > 0)
		{
			char* lpBgl = new char[dwBglSize];
			if (lpBgl)
			{
				bResult = OnFixTotext2(FileText, FileBgl, lpBgl, dwBglSize);
				delete [] lpBgl;
			}
		}

		FileBgl.Close();
	}

	TRY
	{
		FileText.Close();
	}
	CATCH(CFileException, pe)
	{
		CString strTmp;
		BOOL bResult = FileException.GetErrorMessage(strTmp.GetBuffer(256), 256);
		strTmp.ReleaseBuffer();

		if (bResult)
		{
			int nSelect = m_lbcMessage.AddString(strTmp);
			m_lbcMessage.SetCurSel(nSelect);
			m_lbcMessage.UpdateWindow();
		}
	}
	END_CATCH
}

bool CFixDlg::OnFixTotext2(CStdioFile& FileText, CFileAll& FileBgl, char* lpBgl, DWORD dwBglSize)
{
	CFileException FileException;

	if (FileBgl.Read(lpBgl, dwBglSize, &FileException) == dwBglSize)
	{
		CString strTmp;
		UINT uNdb = 0;

		if (*((LPDWORD)(lpBgl + 78)) != 0)
		{
			char* lpSecAdf = lpBgl + *((LPDWORD)(lpBgl + 78));

			for (char* lpRange = lpSecAdf; *lpRange == 0x15; lpRange += 9)
			{
				for (char* lpAdf = lpSecAdf + *((int*)(lpRange + 5)); *lpAdf == 0x04; lpAdf += 42)
				{
					char freqbcd = *((char*)(lpAdf + 1));
					char freqhun = *((char*)(lpAdf + 2));
					char freqdec = *((char*)(lpAdf + 3));
					char freqten = (freqbcd & 0xF0) >> 4;
					char freqone = (freqbcd & 0x0F);
					double freq = (double)freqhun * 100. + (double)freqten * 10. + (double)freqone + (double)freqdec * .1;
					double fLat = GetTriple(lpAdf + 4) * 2.0 * fMetersToDeg;
					double fLon = GetTriple(lpAdf + 7) * 360.0 / 0x1000000;
					short alt = *((short*)(lpAdf + 10));
					char szId[6];
					strncpy(szId, lpAdf + 13, 5)[5] = '\0';
					StrTrimRight(szId);
					char szName[31];
					strncpy(szName, lpAdf + 18, 24)[24] = '\0';
					StrTrimRight(szName);

					if (freq != 0 || alt != 0)
						continue;

					strTmp.Format(_T("%f\t%f\t%s\t%s\n"), fLat, fLon, szId, szName);

					TRY
					{
						FileText.WriteString(strTmp);
					}
					CATCH(CFileException, pe)
					{
						CString strTmp;
						BOOL bResult = FileException.GetErrorMessage(strTmp.GetBuffer(256), 256);
						strTmp.ReleaseBuffer();

						if (bResult)
						{
							int nSelect = m_lbcMessage.AddString(strTmp);
							m_lbcMessage.SetCurSel(nSelect);
							m_lbcMessage.UpdateWindow();
						}

						return false;
					}
					END_CATCH

					uNdb++;
				}
			}
		}

		CString strTmp1;
		strTmp1.LoadString(IDS_INTERSECTIONS_FOUND);
		strTmp.Format(strTmp1, uNdb);
		int nSelect = m_lbcMessage.AddString(strTmp);
		m_lbcMessage.SetCurSel(nSelect);
		m_lbcMessage.UpdateWindow();
	}
	else
	{
		CString strTmp;
		BOOL bResult = FileException.GetErrorMessage(strTmp.GetBuffer(256), 256);
		strTmp.ReleaseBuffer();

		if (bResult)
		{
			int nSelect = m_lbcMessage.AddString(strTmp);
			m_lbcMessage.SetCurSel(nSelect);
			m_lbcMessage.UpdateWindow();
		}
	}

	return true;
}
