// ScenCreate.cpp: Implementierung der Klasse CScenCreate.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "..\Global\FileAll.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


struct tagMagvarRec
{
	tagMagvarRec() { memset(this, 0, sizeof(*this)); }
	short	m_nMagvar[181][360];	// Magvar = -m_nMagvar[Lat + 90][(Lon + 360) % 360] * 360.0 / 0x10000
};

struct tagExclRec
{
	tagExclRec() { memset(this, 0, sizeof(*this)); }
	WORD	m_wExclude;	// Bits: 0x01=visual scenery (runways), 0x02=vor/ils, 0x04=ndb, 0x08=atis
	float	m_fLatMin, m_fLatMax, m_fLonMin, m_fLonMax;
};


long CScenCreate::GetTriple(char* pByte)
{
	return *((long*)(pByte - 1)) >> 8;
}

void CScenCreate::StrTrimRight(char* szText)
{
	for (int nIndex = strlen(szText) - 1; nIndex >= 0 && szText[nIndex] == ' '; szText[nIndex--] = '\0') ;
}


bool CScenCreate::BglFileRead(LPCTSTR lpcszFileName)
{
	USES_CONVERSION;
	CFileAll	File;
	LPSTR		pData;

	if (!File.Open(lpcszFileName, CFile::modeRead | CFile::shareDenyNone))
		return false;

	DWORD dwFileSize = File.GetLength();
	if (dwFileSize == 0)
	{
		File.Close();
		return false;
	}

	if ((pData = new char[dwFileSize]) == NULL)
	{
		File.Close();
		return false;
	}

	if (File.Read(pData, dwFileSize) != dwFileSize)
	{
		File.Close();
		delete [] pData;
		return false;
	}

	File.Close();

	WORD wSceneryID = *((WORD*)&pData[0]);
	if (wSceneryID == 0 || wSceneryID >= 1000)
	{
		delete [] pData;
		return true;
	}

	LPSTR pSec18 = *((DWORD*)&pData[18]) != 0 && *((DWORD*)&pData[18]) < dwFileSize ? pData + *((DWORD*)&pData[18]) : NULL;		// VOR, ILS
	LPSTR pSec58 = *((DWORD*)&pData[58]) != 0 && *((DWORD*)&pData[58]) < dwFileSize ? pData + *((DWORD*)&pData[58]) : NULL;		// bao graphics language
	LPSTR pSec66 = *((DWORD*)&pData[66]) != 0 && *((DWORD*)&pData[66]) < dwFileSize ? pData + *((DWORD*)&pData[66]) : NULL;		// facilities entities
	LPSTR pSec74 = *((DWORD*)&pData[74]) != 0 && *((DWORD*)&pData[74]) < dwFileSize ? pData + *((DWORD*)&pData[74]) : NULL;		// ATIS
	LPSTR pSec78 = *((DWORD*)&pData[78]) != 0 && *((DWORD*)&pData[78]) < dwFileSize ? pData + *((DWORD*)&pData[78]) : NULL;		// NDB
	LPSTR pSec102 = *((DWORD*)&pData[102]) != 0 && *((DWORD*)&pData[102]) < dwFileSize ? pData + *((DWORD*)&pData[102]) : NULL;	// marker and airports
	LPSTR pSec110 = *((DWORD*)&pData[110]) != 0 && *((DWORD*)&pData[110]) < dwFileSize ? pData + *((DWORD*)&pData[110]) : NULL;	// MagVar
	LPSTR pSec114 = *((DWORD*)&pData[114]) != 0 && *((DWORD*)&pData[114]) < dwFileSize ? pData + *((DWORD*)&pData[114]) : NULL;	// Exlude
	DWORD dwMagic = *((DWORD*)&pData[118]);	// magic number 0x87654321

	if (dwMagic == 0x87654321)
		BglFileRead2(pData);

	if (pSec78 != NULL)
	{	// NDB
		for (LPSTR pRange = pSec78; *pRange == 0x15; pRange += 9)
		{	// latitude range
			for (LPSTR pArea = pSec78 + *((DWORD*)(pRange + 5)); *pArea == 0x04; pArea += 42)
			{	// area
				DWORD dwFreq = ((DWORD)*((WORD*)(pArea + 1))) << 4;
				dwFreq |= ((DWORD)*((BYTE*)(pArea + 3)) & 0x0F);
				dwFreq |= ((DWORD)*((BYTE*)(pArea + 3)) & 0xF0) << 12;
				double fFreq = BcdToDWord(dwFreq) * 0.1;
				double fLat = (GetTriple(pArea + 4) << 1) * fMetersToDeg;
				double fLon = (GetTriple(pArea + 7) << 8) * fQuadToLongitude;
				short nAlt = *((short*)(pArea + 10));
				BYTE uRange = *((BYTE*)(pArea + 12));
				char szId[6];
				strncpy(szId, pArea + 13, 5)[5] = '\0';
				StrTrimRight(szId);
				_strupr(szId);
				char szName[31];
				strncpy(szName, pArea + 18, 24)[24] = '\0';
				StrTrimRight(szName);

				if (nAlt == 0 && fFreq == 0)
				{
					if (strlen(szId) == 5)
					{
						if ((
							 isdigit(szId[0]) && isdigit(szId[1]) && isdigit(szId[2]) && isdigit(szId[3]) &&
							 (szId[4] == 'N' || szId[4] == 'E' || szId[4] == 'S' || szId[4] == 'W')
							) ||
							(
							 isdigit(szId[0]) && isdigit(szId[1]) && isdigit(szId[3]) && isdigit(szId[4]) &&
							 (szId[2] == 'N' || szId[2] == 'E' || szId[2] == 'S' || szId[2] == 'W')
							))
							nAlt = 1;
					}
					AddIsec(fLat, fLon, szId, nAlt);
				}
				else
					AddNdb(fLat, fLon, szId, m_NameFile.PutString(szName), nAlt, fFreq, uRange);
			}
		}
	}

	if (pSec18 != NULL)
	{	// VOR and ILS
		WORD wChannelMin = *((WORD*)&pData[22]);
		WORD wChannelMax = *((WORD*)&pData[24]);

		for (int nIndex = 0; nIndex <= wChannelMax - wChannelMin; nIndex++)
		{	// frequency channel
			DWORD dwBandOffset = *((DWORD*)(pSec18 + 5 * nIndex + 1));

			if (*(pSec18 + 5 * nIndex) != 0x01 || dwBandOffset == 0)
				continue;

			double fFreq = 108. + (wChannelMin + nIndex) * .05;

			for (LPSTR pRange = pSec18 + dwBandOffset; *pRange == 0x15; pRange += 9)
			{	// latitude range
				for (LPSTR pAreaNext, pArea = pSec18 + *((DWORD*)(pRange + 5)); *pArea == 0x04 || *pArea == 0x05; pArea = pAreaNext)
				{	// area
					WORD wRange = *((BYTE*)(pArea + 1));
					short nMagvar = *((short*)(pArea + 2));
					WORD wCode = *((BYTE*)(pArea + 4));
					double fLatLoc = (GetTriple(pArea + 5) << 1) * fMetersToDeg;
					double fLonLoc = (GetTriple(pArea + 8) << 8) * fQuadToLongitude;
					short nAlt = *((short*)(pArea + 11));
					WORD wLocDir = *((WORD*)(pArea + 13));
					char szId[6];
					strncpy(szId, pArea + 15, 5)[5] = '\0';
					StrTrimRight(szId);
					_strupr(szId);
					char szName[31];
					strncpy(szName, pArea + 20, 24)[24] = '\0';
					StrTrimRight(szName);

					if (*pArea == 0x05)
					{	// ILS
						long lLatGs = GetTriple(pArea + 44) << 1;
						long lLonGs = GetTriple(pArea + 47) << 8;
						short nAltGs = *((short*)(pArea + 50));
						short nAngleGs = *((short*)(pArea + 52));

						if (lLatGs != 0 && lLonGs != 0)
						{	// Glideslope available
							double fLatGs = lLatGs * fMetersToDeg;
							double fLonGs = lLonGs * fQuadToLongitude;
							double fDist = GlobDist(fLatLoc, fLonLoc, fLatGs, fLonGs);
							double fHead = (wLocDir + 0x8000) * 360.0 / 0x10000;
							GlobPos(fLatGs, fLonGs, fLatLoc, fLonLoc, fHead, fDist);
							AddIls(fLatGs, fLonGs, szId, m_NameFile.PutString(szName), nAltGs, fFreq, wLocDir, nAngleGs, (wCode << 8) | wRange);

							if (m_bBcIls && (wCode & 0x0020) == 0)
							{	// BC available
								AddIls(fLatLoc, fLonLoc, szId, m_NameFile.PutString(szName), nAltGs, fFreq, wLocDir + 0x8000, -1, (wCode << 8) | wRange);
							}
						}

						pAreaNext = pArea + 54;
					}
					else
					{	// VOR
						AddVor(fLatLoc, fLonLoc, szId, m_NameFile.PutString(szName), nAlt, fFreq, nMagvar, (wCode << 8) | wRange);
						pAreaNext = pArea + 44;
					}
				}
			}
		}
	}

	if (pSec74 != NULL)
	{	// ATIS
		for (LPSTR pRange = pSec74; *pRange == 0x15; pRange += 9)
		{	// latitude range
			for (LPSTR pAreaNext, pArea = pSec74 + *((DWORD*)(pRange + 5)); *pArea == 0x04; pArea = pAreaNext)
			{	// area
				double fFreq = 100 + BcdToDWord(*((WORD*)(pArea + 1))) * .01;
				double fLat = (GetTriple(pArea + 3) << 1) * fMetersToDeg;
				double fLon = (GetTriple(pArea + 6) << 8) * fQuadToLongitude;
				BYTE uRange = *((BYTE*)(pArea + 9));
				pAreaNext = pArea + *((WORD*)(pArea + 10));
				DWORD dwRunways = *((DWORD*)(pArea + 12));
				AddAtis(fLat, fLon, dwRunways, fFreq, uRange);
			}
		}
	}

	if (pSec66 != NULL)
	{	// facilities entities
		for (LPSTR pCountryNext, pCountry = pSec66; *pCountry == 0x01; pCountry = pCountryNext)
		{	// Country
			pCountryNext = pCountry + *((WORD*)(pCountry + 1));
			char* lpszCountryName = pCountry + 7;

			for (LPSTR pStateNext, pState = pSec66 + *((DWORD*)(pCountry + 3)); *pState == 0x03; pState = pStateNext)
			{	// State
				pStateNext = pState + *((WORD*)(pState + 1));
				double fLat = (*((long*)(pState + 3)) >> 7) * fMetersToDeg;
				double fLon = *((long*)(pState + 7)) * fQuadToLongitude;
				short nAlt = (short)(*((long*)(pState + 11)) / 256);
				// create an name
				CString strName = A2CT(pState + 27);
				int nPos = strName.Find(_T("(created with Scenery MAKER)"));
				if (nPos <= 0)
					nPos = strName.Find(_T("Airport"));
				if (nPos <= 0)
					nPos = strName.Find(_T("airport"));
				if (nPos <= 0)
					nPos = strName.Find(_T("Runway"));
				if (nPos <= 0)
					nPos = strName.Find(_T("runway"));
				if (nPos <= 0)
					nPos = strName.Find(_T("Hold Short"));	
				if (nPos <= 0)
					nPos = strName.Find(_T("Rway"));	
				if (nPos <= 0)
					nPos = strName.Find(_T("RWAY"));	
				if (nPos <= 0)
					nPos = strName.Find(_T("rwy"));	
				if (nPos <= 0)
					nPos = strName.Find(_T("Rwy"));	
				if (nPos <= 0)
					nPos = strName.Find(_T("RWY"));	
				if (nPos <= 0)
					nPos = strName.Find(_T("Ramp"));	
				if (nPos <= 0)
					nPos = strName.Find(_T("RAMP"));	
				if (nPos <= 0)
					nPos = strName.Find(_T("Parked"));	
				if (nPos <= 0)
					nPos = strName.Find(_T("Parking"));	
				if (nPos <= 0)
					nPos = strName.Find(_T("parking"));	
				if (nPos <= 0)
					nPos = strName.Find(_T("Fuel"));	
				if (nPos <= 0)
					nPos = strName.Find(_T("fuel"));	
				if (nPos <= 0)
					nPos = strName.Find(_T("Terminal"));	
				if (nPos <= 0)
					nPos = strName.Find(_T("terminal"));	
				if (nPos <= 0)
					nPos = strName.Find(_T(" at "));	
				if (nPos <= 0)
					nPos = strName.Find(_T(" in "));	
				if (nPos > 0)
					strName = strName.Mid(0, nPos);

				strName.TrimRight();

				while (strName.Right(1) == _T("-"))
					strName = strName.Left(strName.GetLength() - 1);

				strName.TrimRight();

				if (strName.GetLength() > 0)
				{
					char szName[31];
					strncpy(szName, T2CA(strName), 30)[30] = '\0';
					AddAirport(fLat, fLon, m_NameFile.PutString(szName), nAlt);
				}
			}
		}
	}

	if (pSec102 != NULL)
	{	// marker and landme
		for (LPSTR pRange = pSec102; *pRange == 0x15; pRange += 9)
		{	// latitude range
			for (LPSTR pAreaNext, pArea = pSec102 + *((DWORD*)(pRange + 5)); *pArea >= 0x04 && *pArea <= 0x07; pArea = pAreaNext)
			{	// area
				pAreaNext = pArea + *((BYTE*)(pArea + 1));

				if (*pArea == 0x04)
				{	// inner marker
					double fLat = (GetTriple(pArea + 2) << 1) * fMetersToDeg;
					double fLon = (GetTriple(pArea + 5) << 8) * fQuadToLongitude;
					short nAlt = *((short*)(pArea + 8));
					AddMarker(MARKERINNER, fLat, fLon, nAlt);
				}
				else if (*pArea == 0x05)
				{	// middle marker
					double fLat = (GetTriple(pArea + 2) << 1) * fMetersToDeg;
					double fLon = (GetTriple(pArea + 5) << 8) * fQuadToLongitude;
					short nAlt = *((short*)(pArea + 8));
					AddMarker(MARKERMIDDLE, fLat, fLon, nAlt);
				}
				else if (*pArea == 0x06)
				{	// outer marker
					double fLat = (GetTriple(pArea + 2) << 1) * fMetersToDeg;
					double fLon = (GetTriple(pArea + 5) << 8) * fQuadToLongitude;
					short nAlt = *((short*)(pArea + 8));
					AddMarker(MARKEROUTER, fLat, fLon, nAlt);
				}
				else if (*pArea == 0x07)
				{	// landme
					double fLat = (GetTriple(pArea + 2) << 1) * fMetersToDeg;
					double fLon = (GetTriple(pArea + 5) << 8) * fQuadToLongitude;
					short nAlt = *((short*)(pArea + 9));
					char szName[31];
					strncpy(szName, pArea + 22, 30)[30] = '\0';
					CString strName = A2CT(szName);
					int nPos = strName.Find(_T("Runway"));
					if (nPos <= 0)
						nPos = strName.Find(_T("runway"));
					if (nPos <= 0)
						nPos = strName.Find(_T("Rway"));
					if (nPos <= 0)
						nPos = strName.Find(_T("RWAY"));
					if (nPos <= 0)
						nPos = strName.Find(_T("rwy"));
					if (nPos <= 0)
						nPos = strName.Find(_T("Rwy"));
					if (nPos <= 0)
						nPos = strName.Find(_T("RWY"));
					if (nPos > 0)
						strName = strName.Mid(0, nPos);
					strName.TrimRight();
					if (strName.GetLength() > 0)
					{
						strncpy(szName, T2CA(strName), 30)[30] = '\0';
						AddAirport(fLat, fLon, m_NameFile.PutString(szName), nAlt);
					}
				}
			}
		}
	}

	if (pSec58 != NULL)
	{	// bao graphics language
		for (LPSTR pRange = pSec58; *pRange == 0x15; pRange += 9)
		{	// latitude range
			bool bRangeNew = true;

			for (LPSTR pAreaNext, pArea = pSec58 + *((DWORD*)(pRange + 5)); ; pArea = pAreaNext)
			{	// area
				if (*pArea != 0x05 && *pArea != 0x08 && *pArea != 0x0B)
					break;
#ifdef _DEBUG
				WORD wRecCodeLast0 = 0, wRecCodeLast1 = 0, wRecCodeLast2 = 0, wRecCodeLast3 = 0, wRecCodeLast4 = 0, wRecCodeLast5 = 0,
					 wRecCodeLast6 = 0, wRecCodeLast7 = 0, wRecCodeLast8 = 0, wRecCodeLast9 = 0, wRecCodeLastA = 0, wRecCodeLastB = 0;
#endif
				CPtrArray	JumpArray;		// ist schneller als CArray<LPSTR, LPSTR> weil keine Destruktoren aufgerufen werden
				JumpArray.SetSize(0, 100);
				CPtrList	CommandList;	// ist schneller als CList<LPSTR, LPSTR> weil keine Destruktoren aufgerufen werden
				pAreaNext = pArea + *((WORD*)(pArea + 10));

				for (LPSTR pCode = pArea + 12; ; )
				{
					int nUpperBound;
					while (pCode >= pAreaNext && (nUpperBound = JumpArray.GetUpperBound()) >= 0)
					{
						LPSTR pCodeTmp = (LPSTR)JumpArray.GetAt(nUpperBound);
						JumpArray.RemoveAt(nUpperBound);

						if (!CommandList.Find(pCodeTmp))
							pCode = pCodeTmp;
					}

					if (pCode >= pAreaNext)
						break;

					CommandList.AddTail(pCode);

					WORD wRecCode = *((WORD*)pCode);
					switch (wRecCode)
					{
					case 0x00:	// EOF
						pCode = pAreaNext;
						break;
					case 0x01:	// LogolFormat
						pCode = pAreaNext;
						break;
					case 0x16:	// ExitSDL16
						pCode = pAreaNext;
						break;
					case 0x17:	// ExitSDL17
						pCode = pAreaNext;
						break;
					case 0x22:	// Return
						pCode = pAreaNext;
						break;
					case 0x02:	// Nop
					case 0x04:	// Debug
					case 0x05:	// StartSurface
					case 0x08:	// CloseSurface
					case 0x09:	// StartDrawing
					case 0x0C:	// CloseDrawing
					case 0x1B:	// MonitorTr
					case 0x2B:	// Nop2B
					case 0x38:	// Concave
					case 0x42: 	// StartDefRunway
					case 0x64:	// NotUse
					case 0x76:	// SwitchToBgl
					case 0x7D:	// PerspectiveOverride
					case 0x7F:	// City
						pCode += 2;
						break;
					case 0x0F:	// MoveToPoint
					case 0x10:	// LineToPoint
					case 0x12:	// MoveToPPoint
					case 0x13:	// LineToPPoint
					case 0x14:	// SurfaceCol14
					case 0x1E:	// SetHazeFactor
					case 0x1F:	// SetGroundPlotting
					case 0x30:	// SurfColIntensity
					case 0x40:	// ShadowVPosition
					case 0x47:	// MapScale
					case 0x48:	// SetLocSeg
					case 0x50:	// GradColour
					case 0x51:	// LineColour
					case 0x53:	// GouraudShadedColor
					case 0x59:	// VarSecID
					case 0x5B:	// CallInd
					case 0x5E:	// BitmapRotate
					case 0x65:	// SurfColInd
					case 0x66:	// GradColInd
					case 0x67:	// LineColInd
					case 0x71:	// AltitudeSet
					case 0x80:	// DotToPoint
					case 0x81:	// Smoothing
					case 0x87:	// FixedColors
					case 0x88:	// FileNumberMarker
						pCode += 4;
						break;
					case 0x2D:	// Col2D
					case 0x2E:	// Col2E
					case 0x4D:	// EquVarToLocVar
					case 0x4E:	// EquLocVarToVar
					case 0x4F:	// EquVar
					case 0x54:	// CallASM
					case 0x5C:	// FarCall
					case 0x61:	// NotUse
					case 0x7E:	// SetVar
						pCode += 6;
						break;
					case 0x06:	// MoveTo
					case 0x07:	// LineTo
					case 0x37:	// Dot
					case 0x5D:	// RepeatBitmap
					case 0x68:	// TextureShading
					case 0x6A:	// RoadContinue
					case 0x6C:	// RiverContinue
						pCode += 8;
						break;
					case 0x0A:	// StartSurfaceDefinition
					case 0x0B:	// ContinueSurfaceDefinition
					case 0x28:	// BigDot
					case 0x57:	// Weather
					case 0x69:	// RoadStart
					case 0x6B:	// RiverStart
					case 0x78:	// RoadContW
					case 0x79:	// RiverContW
					case 0x84:	// SurfaceNormal
						pCode += 10;
						break;
					case 0x11:	// DefPPoint
						pCode += 12;
						break;
					case 0x19:	// Palette
					case 0x35:	// DottedLine
					case 0x45:	// DottedStrobeLine
						pCode += 16;
						break;
					case 0x31:	// DefPointArray
					case 0x49:	// Building
					case 0x58:	// MoveTexture
						pCode += 18;
						break;
					case 0x72:	// EndLights
					case 0x82:	// ShadowPosition
						pCode += 20;
						break;
					case 0x18:	// Texture
					case 0x3D:	// Seed
						pCode += 24;
						break;
					case 0x03:	// Switch
						{
							WORD wSwitchOffs;
							WORD wCases = *((WORD*)(pCode + 2));
							for (WORD wIndex = 0; wIndex < wCases; wIndex++)
							{
								if (wSwitchOffs = *((WORD*)(pCode + 8 + wIndex * 2)))
									JumpArray.Add(pCode + wSwitchOffs);
							}
							wSwitchOffs = *((WORD*)(pCode + 6));
							if (wSwitchOffs == 0)
								pCode = pAreaNext;
							else
								pCode += wSwitchOffs;
							break;
						}
					case 0x0D:	// Jump
						pCode += *((WORD*)(pCode + 2));
						break;
					case 0x0E:	// DefPoint
						pCode += 10;
						break;
					case 0x15:	// DefSurface
						{
							WORD wXGridSize = *((WORD*)(pCode + 2));
							WORD wYGridSize = *((WORD*)(pCode + 4));
							pCode += 18 + 4 * (wXGridSize + 1) * (wYGridSize + 1);
							break;
						}
					case 0x1A:	// DefPoints
						{
							WORD wNumPoints = *((WORD*)(pCode + 4));
							pCode += 6 + 6 * wNumPoints;
							break;
						}
					case 0x1C:	// ??
						pCode += *(LPWORD(pCode + 2));
						break;
					case 0x1D:	// VPPolygon
						{
							WORD wNumPoints = *((WORD*)(pCode + 2));
							pCode += 16 + 2 * wNumPoints;
							break;
						}
					case 0x20:	// TexturePolygon
						{
							WORD wNumPoints = *((WORD*)(pCode + 2));
							pCode += 14 + 6 * wNumPoints;
							break;
						}
					case 0x21:	// SuperMesh	???????????????????????????????????????????????????
						pCode += 22;
						break;
					case 0x23:	// BGLCall
						JumpArray.Add(pCode + 4);
						pCode += *((WORD*)(pCode + 2));
						break;
					case 0x5A:	// SeedAddObjectCall
					case 0x32:	// PerspectiveCall
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 4;
						break;
					case 0x24:	// JumpOnVar
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 10;
						break;
					case 0x25:	// JumpOnVect
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 14;
						break;
					case 0x26:	// SetLocVar
						pCode += 6;
						break;
					case 0x27:	// TextureWindow
						{
							WORD wNumPoints = *((WORD*)(pCode + 2));
							pCode += 14 + 2 * wNumPoints;
							break;
						}
					case 0x29:	// DefVectPoints
						{
							WORD wNumPoints = *((WORD*)(pCode + 4));
							pCode += 6 + 12 * wNumPoints;
							break;
						}
					case 0x2A:	// GradPolygon
						{
							WORD wNumPoints = *((WORD*)(pCode + 2));
							pCode += 14 + 2 * wNumPoints;
							break;
						}
					case 0x2C:	// CondJump2C
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 12;
						break;
					case 0x2F:	// CondRefPoint
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 32;
						break;
					case 0x33:	// RotoCall
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 10;
						break;
					case 0x34:	// SuperScale
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 10;
						break;
					case 0x36:	// PatternLine ?????????????????????????????????????????????????????????????????????????????
						{
							WORD wNumDots = *((WORD*)(pCode + 14));
							pCode += 16 + 2 * (wNumDots / 16 + 1);
							break;
						}
					case 0x39:	// TestVar
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 8;
						break;
					case 0x3A:	// CondNSRefPointInd
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 12;
						break;
					case 0x3B:	// VInstanceCall
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 6;
						break;
					case 0x3C:	// CondNSRefPoint
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 28;
						break;
					case 0x3E:	// Polygon
						{
							WORD wNumPoints = *((WORD*)(pCode + 2));
							pCode += 14 + 2 * wNumPoints;
							break;
						}
					case 0x3F:	// ShadowCall
//						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 4;
						break;
					case 0x41:	// ShadowVInstanceCall
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 6;
						break;
					case 0x44:	// Runway
						Runway(pCode);
						pCode += 64;
						break;
					case 0x46:	// RotoCallInd
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 22;
						break;
					case 0x4A:	// LandingLightsCall
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 12;
						break;
					case 0x4B:	// OverlayCall
						pCode += *((WORD*)(pCode + 2));
						break;
					case 0x4C:	// CondRefPointInd
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 16;
						break;
					case 0x52:	// SurfColour
						pCode += 4;
						break;
					case 0x55:	// SetSurfaceType	?????????????????????????????????????????????
						pCode += 10;
						break;
					case 0x56:	// SetWeather
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 4;
						break;
					case 0x5F:	// CondJump5F
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 8;
						break;
					case 0x60:	// Polygon60
						{
							WORD wNumPoints = *((WORD*)(pCode + 2));
							pCode += 16 + 6 * wNumPoints;
							break;
						}
					case 0x62:	// PointList
						{
							JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
							WORD wNumPoints = *((WORD*)(pCode + 4));
							pCode += 6 + 2 * wNumPoints;
							break;
						}
					case 0x6D:	// IfHRes
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 8;
						break;
					case 0x6E:	// TaxiwayStart
						pCode += 10;
						break;
					case 0x6F:	// TaxiwayEnd
						pCode += 8;
						break;
					case 0x70:	// AreaSense
						{
							JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
							WORD wNumPoints = *((WORD*)(pCode + 4));
							pCode += 6 + 4 * wNumPoints;
							break;
						}
					case 0x73:	// JumpOnCude
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 16;
						break;
					case 0x74:	// LayerCall
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 6;
						break;
					case 0x75:	// AddMountain
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 4;
						break;
					case 0x77:	// ScaleAgl
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 32;
						break;
					case 0x7A:	// TexturePolygon7A
						{
							WORD wNumPoints = *((WORD*)(pCode + 2));
							pCode += 14 + 6 * wNumPoints;
							break;
						}
					case 0x7B:	// TexturePolygon7B
						{
							WORD wNumPoints = *((WORD*)(pCode + 2));
							pCode += 16 + 6 * wNumPoints;
							break;
						}
					case 0x7C:	// PolyLineFacet
						{
							WORD wNumPoints = *((WORD*)(pCode + 2));
							pCode += 14 + 2 * wNumPoints;
							break;
						}
					case 0x83:	// ScaleFactor
						JumpArray.Add(pCode + *((WORD*)(pCode + 2)));
						pCode += 12;
						break;
					case 0x8C:	// CallDll
						{
							WORD wNum = *((WORD*)(pCode + 8));
							pCode += 6 + wNum;
							break;
						}
					case 0x8d:	// ??
						pCode += 2 + 6 * 26;
						break;
					case 0x90:	// OK
						{
							WORD wNumPoints = *((WORD*)(pCode + 2));
							pCode += (15 + wNumPoints + 1) / 2 * 2;
							break;
						}
					case 0xA8:	// FS2000 ROAD start	OK
						pCode += 12;
						break;
					case 0xA0:	// FS2000	OK?
						{
							WORD wSize = *(LPWORD(pCode + 2));
							pCode += wSize;
							break;
						}
					case 0xAA:	// FS2000	OK?
						{
							WORD wSize = *(LPWORD(pCode + 2));
							pCode += wSize;
							break;
						}
					case 0xAC:	// FS2000	OK
						pCode += 4;
						break;
					case 0x63:	// Call BglLibrary	OK?
						pCode += 20;
						break;
					case 0x43:	// FS2000 LoadBitmap	OK
						{
							WORD wSize = *(LPWORD(pCode + 2));
							pCode += wSize;
							break;
						}
					default:
						pCode = pAreaNext;
						break;
					}
#ifdef _DEBUG
					wRecCodeLastB = wRecCodeLastA;
					wRecCodeLastA = wRecCodeLast9;
					wRecCodeLast9 = wRecCodeLast8;
					wRecCodeLast8 = wRecCodeLast7;
					wRecCodeLast7 = wRecCodeLast6;
					wRecCodeLast6 = wRecCodeLast5;
					wRecCodeLast5 = wRecCodeLast4;
					wRecCodeLast4 = wRecCodeLast3;
					wRecCodeLast3 = wRecCodeLast2;
					wRecCodeLast2 = wRecCodeLast1;
					wRecCodeLast1 = wRecCodeLast0;
					wRecCodeLast0 = wRecCode;
#endif
				}
			}
		}
	}

	if (pSec110 != NULL)
	{	// MagVar
		tagMagvarRec	MagvarRec;

		for (int nLat = 0; nLat <= 180; nLat++)
		{
			for (int nLon = 0; nLon < 360; nLon++)
			{
				MagvarRec.m_nMagvar[nLat][nLon] = *((short*)(pSec110 + 8 + (nLon * 181 + nLat) * 2));
			}
		}

		m_Magvar.Add(MagvarRec);
	}

	if (pSec114 != NULL)
	{	// Exclude
		for (LPSTR pAreaNext, pArea = pSec114; *pArea == 0x03; pArea = pAreaNext)
		{	// area
			pAreaNext = pArea + 19;
			tagExclRec	ExclRec;
			ExclRec.m_wExclude = *((WORD*)(pArea + 1));	// Bits: 0x01=visual scenery (runways), 0x02=vor/ils, 0x04=ndb, 0x08=atis
			ExclRec.m_fLatMax = (float)(*((long*)(pArea + 3)) * fMetersToDeg);
			ExclRec.m_fLatMin = (float)(*((long*)(pArea + 7)) * fMetersToDeg);
			ExclRec.m_fLonMax = (float)(*((long*)(pArea + 11)) * fQuadToLongitude);
			ExclRec.m_fLonMin = (float)(*((long*)(pArea + 15)) * fQuadToLongitude);
			m_Exclude.Add(ExclRec);
		}
	}

	delete [] pData;
	return true;
}

void CScenCreate::Runway(LPSTR pData)
{
	double fLat = *((long*)&pData[4]) * fMetersToDeg;
	double fLon = *((long*)&pData[10]) * fQuadToLongitude;
	short nAlt = *((short*)&pData[16]);
	WORD wCourse = *((WORD*)&pData[20]);
	WORD wLength = *((WORD*)&pData[22]);
	WORD wWidth = *((WORD*)&pData[24]);
	BYTE uID = *((BYTE*)&pData[27]);
	char cSurface = *((char*)&pData[30]);

	double fLength = wLength * fFtToMeters;
	if (fLength > 300)
		fLength -= 60;
	double fCourse = wCourse * 360.0 / 0x10000;
	double fdy = fLength * cos(fCourse * fDegToRad);
	double fdx = fLength * sin(fCourse * fDegToRad);

	double fLat1 = fLat - (360 * fdy * .5 / fEarthCircumference);
	double fLon1 = fLon - (360 * fdx * .5 / (fEarthCircumference * cos(fLat * fDegToRad)));
	if (fLon1 > 180)
		fLon1 -= 360;
	else if (fLon1 < -180)
		fLon1 += 360;

	double fLat2 = fLat + (360 * fdy * .5 / fEarthCircumference);
	double fLon2 = fLon + (360 * fdx * .5 / (fEarthCircumference * cos(fLat * fDegToRad)));
	if (fLon2 > 180)
		fLon2 -= 360;
	else if (fLon2 < -180)
		fLon2 += 360;

	char szId[6];
	BYTE uID1 = uID & 0x3F;
	uID >>= 6;

	if (uID == 0x03)
		szId[sprintf(szId, "%uC", uID1) + 1] = cSurface;
	else if (uID == 0x02)
		szId[sprintf(szId, "%uR", uID1) + 1] = cSurface;
	else if (uID == 0x01)
		szId[sprintf(szId, "%uL", uID1) + 1] = cSurface;
	else
		szId[sprintf(szId, "%u", uID1) + 1] = cSurface;

	AddRunway(fLat1, fLon1, szId, nAlt, wCourse, wWidth, wLength);

	if ((uID1 += 18) > 36)
		uID1 -= 36;

	if (uID == 0x03)
		szId[sprintf(szId, "%uC", uID1) + 1] = cSurface;
	else if (uID == 0x02)
		szId[sprintf(szId, "%uL", uID1) + 1] = cSurface;
	else if (uID == 0x01)
		szId[sprintf(szId, "%uR", uID1) + 1] = cSurface;
	else
		szId[sprintf(szId, "%u", uID1) + 1] = cSurface;

	AddRunway(fLat2, fLon2, szId, nAlt, wCourse + 0x8000, wWidth, wLength);
}

////////////////////////

enum ENUM32_STRING
{
	STRINGZ_ASCII		= 0	// OK
};

enum ENUM32_CONTAINER
{
	CONTAINER_NAMED		= 0x00000000,	// Helper
	CONTAINER_AIRPORT	= 0x00000001,	// OK
	CONTAINER_VOR		= 0x00000002,	// OK
	CONTAINER_NDB		= 0x00000003,	// OK
	CONTAINER_FIXPOINT	= 0x00000006,	// OK
	CONTAINER_AIRWAY_V	= 0x00000007,	// OK
	CONTAINER_AIRWAY_J	= 0x00000008,	// OK
};


enum ENUM32_FACILITY
{
	FACILITY_REGION		= 0x00010001,	// OK
	FACILITY_COUNTRY	= 0x00020001,	// OK
	FACILITY_STATE		= 0x00030001,	// OK
	FACILITY_CITY		= 0x00040001,	// OK
	FACILITY_AIRPORT	= 0x00050001,	// OK
	FACILITY_VOR		= 0x00050003,	// OK
	FACILITY_NDB		= 0x00050004,	// OK
};

enum ENUM32_LOCTYPE
{
	OBJECT_NULL			= 0x00000000,	// OK
	OBJECT_CONTAINER	= 0x00000001,	// OK

	LOCATION_AIRPORT	= 0x00010001,	// OK
	LOCATION_RUNWAY		= 0x00010002,	// OK
	LOCATION_TOWER		= 0x00010003,
	LOCATION_NAVAID		= 0x00010004,	// OK
	LOCATION_SET		= 0x00010005,	// OK
	ICAO_ID				= 0x00010006,	// OK
	LOCATION_FIXPOINT	= 0x00010008,	// OK
	LOCATION_AIRWAY		= 0x00011002,	// OK
	FREQUENCY			= 0x00020001,	// OK

	NAME_LIST			= 0x00030001,	// OK
	NAME_ENTRY			= 0x00030002,	// OK
};

enum ENUM32_RUNWAY
{
	RUNWAY				= 0x00000000,	// OK
	RUNWAY_LEFT			= 0x00000001,	// OK
	RUNWAY_RIGHT		= 0x00000002,	// OK
	RUNWAY_CENTER		= 0x00000003,	// OK
	HELIPAD				= 0x00000004,
};

enum ENUM32_NAVAIDTYPE
{
	NAVAID_VOR			= 0x00000001,	// OK
	NAVAID_DME			= 0x00000002,	// OK
	NAVAID_NDB			= 0x00000003,	// OK
	NAVAID_LOCALIZER	= 0x00000004,	// OK
	NAVAID_GLIDESLOPE	= 0x00000005,	// OK
	NAVAID_SDF			= 0x00000006,
	NAVAID_MARKER		= 0x00000007,	// OK
	NAVAID_TACAN		= 0x00000008,	// OK
};

enum ENUM32_NAVAIDCLASS
{
	NOT_SPECIFIC		= 0x00000000,	// OK
	SSV_TERMINAL		= 0x00000001,	// OK
	SSV_LOW_ALTITUDE	= 0x00000002,	// OK
	SSV_HIGH_ALTITUDE	= 0x00000003,	// OK
	NDB_COMPASS_LOCATOR	= 0x00000004,	// OK
	NDB_MH				= 0x00000005,	// OK
	NDB_H				= 0x00000006,	// OK
	NDB_HH				= 0x00000007,	// OK
	MARKER_OM			= 0x00000008,	// OK
	MARKER_MM			= 0x00000009,	// OK
	MARKER_IM			= 0x0000000A,	// OK
	MARKER_BC			= 0x0000000B,	// OK
};

enum ENUM32_SURFACE
{
	SURFACE_UNKNOWN		= 0x00000000,	// OK
	SURFACE_DIRT		= 0x00000001,	// OK
	SURFACE_CEMENT		= 0x00000002,	// OK
	SURFACE_ASPHALT		= 0x00000003,	// OK
	SURFACE_GRASS		= 0x00000004,	// OK
	SURFACE_GRAVEL		= 0x00000005,	// OK
	SURFACE_OIL_TREATED	= 0x00000006,	// OK
	SURFACE_MATS		= 0x00000007,	// OK
	SURFACE_SNOW		= 0x00000008,	// OK
	SURFACE_CORAL		= 0x00000009,	// OK
	SURFACE_WATER		= 0x0000000A,	// OK
};

enum ENUM32_FREQUENCY
{
	FREQ_ATIS			= 0x00000001,	// OK
	FREQ_MULTICOM		= 0x00000002,
	FREQ_UNICOM			= 0x00000003,
	FREQ_CTAF			= 0x00000004,
	FREQ_GNDCON			= 0x00000005,
	FREQ_CT				= 0x00000006,
	FREQ_CDEL			= 0x00000007,
	FREQ_APCON			= 0x00000008,
	FREQ_DEPCON			= 0x00000009,
	FREQ_CENTER			= 0x0000000A,
	FREQ_FSS			= 0x0000000B,
	FREQ_AWOS			= 0x0000000C,
};

////////////////////////

#pragma pack(push, 2)
struct tagIF48
{
	WORD	m_wReserved;
	WORD	m_wLo;
	long	m_lHi;
};
#pragma pack(pop)

#pragma pack(push, 4)
struct tagLocationAirport
{
	ENUM32_LOCTYPE	m_dwType;
	DWORD			m_dwSize;
	tagIF48			m_Lat;
	tagIF48			m_Lon;
	tagIF48			m_Alt;
	DWORD			m_dwHead;
};

struct tagIcaoId
{
	ENUM32_LOCTYPE	m_dwType;
	DWORD			m_dwSize;
	char			m_szId[4];
};

struct tagLocationRunway
{
	ENUM32_LOCTYPE	m_dwType;
	DWORD			m_dwSize;
	tagIF48			m_Lat;
	tagIF48			m_Lon;
	tagIF48			m_Alt;
	DWORD			m_dwHead;
	DWORD			m_dwMagVar;
	DWORD			m_dwLength;
	DWORD			m_dwWidth;
	ENUM32_RUNWAY	m_dwTypeRunway;
	DWORD			m_dwNumber;
	ENUM32_SURFACE	m_Surface;
	DWORD			m_dwReserved;
};

struct tagLocationSet
{
	ENUM32_LOCTYPE	m_dwType;
	DWORD			m_dwSize;
	tagIF48			m_Lat;
	tagIF48			m_Lon;
	tagIF48			m_Alt;
	DWORD			m_dwHead;
	DWORD			m_dwTypeSet;
	DWORD			m_dwTypeSub;
	DWORD			m_dwNumber;
	DWORD			m_dwReserved;
};

struct tagLocationTower
{
	ENUM32_LOCTYPE	m_dwType;
	DWORD			m_dwSize;
	tagIF48			m_Lat;
	tagIF48			m_Lon;
	tagIF48			m_Alt;
	DWORD			m_dwHead;
};

struct tagFrequency
{
	ENUM32_LOCTYPE		m_dwType;
	DWORD				m_dwSize;
	DWORD				m_dwFreq;
	ENUM32_FREQUENCY	m_dwTypeFreq;
};

struct tagLocationNavaid
{
	ENUM32_LOCTYPE		m_dwType;
	DWORD				m_dwSize;
	tagIF48				m_Lat;
	tagIF48				m_Lon;
	tagIF48				m_Alt;
	DWORD				m_dwHead;
	DWORD				m_dwFreq;
	ENUM32_NAVAIDTYPE	m_dwTypeNavaid;
	ENUM32_NAVAIDCLASS	m_dwClass;
	DWORD				m_dwFlags;
	DWORD				m_dwReserved;
	char				m_szId[4];
};

struct tagLocationFix
{
	ENUM32_LOCTYPE		m_dwType;
	DWORD				m_dwSize;
	tagIF48				m_Lat;
	tagIF48				m_Lon;
	DWORD				m_dwFlags;
	char				m_szId[4];
};

struct tagLocationAirway
{
	ENUM32_LOCTYPE		m_dwType;
	DWORD				m_dwSize;
	char				m_szId[4];
};

struct tagObject
{
	ENUM32_LOCTYPE		m_dwType;
	DWORD				m_dwSize;
	char				m_cData[1];
};

struct tagObjContainer
{
	ENUM32_LOCTYPE		m_dwType;
	DWORD				m_dwSize;
	ENUM32_CONTAINER	m_dwContainerType;
	DWORD				m_dwReserved;
	tagObject			m_Object[1];
};

struct tagNameEntry
{
	ENUM32_LOCTYPE		m_dwType;
	DWORD				m_dwSize;
	ENUM32_FACILITY		m_dwFacilityType;
	DWORD				m_dwObjectPtr;
	char				m_szName[4];
};

struct tagNameList
{
	ENUM32_LOCTYPE		m_dwType;
	DWORD				m_dwSize;
	DWORD				m_dwLanguageID;
	ENUM32_STRING		m_dwStringType;
	DWORD				m_dwReserved;
	DWORD				m_dwNameEntryCount;
	tagObject			m_Object[1];
};
#pragma pack(pop)

////////////////////////

void CScenCreate::BglFileRead2(LPSTR pData)
{
	DWORD dwVersion =  *((DWORD*)&pData[144]);			// Version
	if (dwVersion != 1)
		return;

	DWORD dwPtrCount = *((DWORD*)&pData[148]);			// Data pointers count
	DWORD dwPtrList = *((DWORD*)&pData[152]);			// Data pointer list
	DWORD dwFacility2NameList = *((DWORD*)&pData[156]);	// Facility2 name list
	DWORD dwFacility2Data = *((DWORD*)&pData[164]);		// Facility2 data

	if (dwFacility2NameList != 0)
		BglFileRead2NameList(pData, (tagObject*)(pData + dwFacility2NameList));

	if (dwFacility2Data != 0)
		BglFileRead2Data(pData, (tagObject*)(pData + dwFacility2Data));
}

void CScenCreate::BglFileRead2NameList(LPSTR pData, tagObject* pObject)
{
	for ( ; ; )
	{
		if (pObject->m_dwType == OBJECT_NULL)
			break;

		if (pObject->m_dwType == NAME_LIST)
			BglFileRead2NameEntry(pData, pObject);
		else
			ASSERT(0);

		pObject = (tagObject*)(pObject->m_cData + pObject->m_dwSize);
	}
}

void CScenCreate::BglFileRead2NameEntry(LPSTR pData, tagObject* pObject)
{
	tagNameList& NameList = *(tagNameList*)pObject;
	pObject = NameList.m_Object;
	bool bEnglishAscii = (NameList.m_dwLanguageID == MAKELANGID(LANG_ENGLISH, SUBLANG_DEFAULT) && NameList.m_dwStringType == STRINGZ_ASCII);

	for (DWORD dwNameEntry = 0; dwNameEntry < NameList.m_dwNameEntryCount; dwNameEntry++)
	{
		if (pObject->m_dwType == NAME_ENTRY)
		{
			tagNameEntry& NameEntry = *(tagNameEntry*)pObject;
			char szName[31];
			strncpy(szName, NameEntry.m_szName, min(30, pObject->m_cData + pObject->m_dwSize - NameEntry.m_szName))[30] = '\0';
			tagObjContainer& ObjContainer = *(tagObjContainer*)(pData + NameEntry.m_dwObjectPtr);

			switch (NameEntry.m_dwFacilityType)
			{
			case FACILITY_REGION:
			case FACILITY_COUNTRY:
			case FACILITY_STATE:
			case FACILITY_CITY:
				break;
			case FACILITY_AIRPORT:
				if (NameEntry.m_dwObjectPtr != NULL && ObjContainer.m_dwType == OBJECT_CONTAINER)
				{
					if (ObjContainer.m_dwContainerType == CONTAINER_AIRPORT)
					{
						if (bEnglishAscii)
							BglFileRead2Airport(m_NameFile.PutString(szName), ObjContainer.m_Object);

						ObjContainer.m_dwContainerType = CONTAINER_NAMED;
					}
					else if (ObjContainer.m_dwContainerType != CONTAINER_NAMED)
						ASSERT(0);
				}
				else
					ASSERT(0);
				break;
			case FACILITY_VOR:
				if (NameEntry.m_dwObjectPtr != NULL && ObjContainer.m_dwType == OBJECT_CONTAINER)
				{
					if (ObjContainer.m_dwContainerType == CONTAINER_VOR)
					{
						if (bEnglishAscii)
							BglFileRead2Vor(m_NameFile.PutString(szName), ObjContainer.m_Object);

						ObjContainer.m_dwContainerType = CONTAINER_NAMED;
					}
					else if (ObjContainer.m_dwContainerType != CONTAINER_NAMED)
						ASSERT(0);
				}
				else
					ASSERT(0);
				break;
			case FACILITY_NDB:
				if (NameEntry.m_dwObjectPtr != NULL && ObjContainer.m_dwType == OBJECT_CONTAINER)
				{
					if (ObjContainer.m_dwContainerType == CONTAINER_NDB)
					{
						if (bEnglishAscii)
							BglFileRead2Ndb(m_NameFile.PutString(szName), ObjContainer.m_Object);

						ObjContainer.m_dwContainerType = CONTAINER_NAMED;
					}
					else if (ObjContainer.m_dwContainerType != CONTAINER_NAMED)
						ASSERT(0);
				}
				else
					ASSERT(0);
				break;
			default:
				ASSERT(0);
				break;
			}
		}
		else
			ASSERT(0);

		pObject = (tagObject*)(pObject->m_cData + pObject->m_dwSize);
	}
}

void CScenCreate::BglFileRead2Data(LPSTR pData, tagObject* pObject)
{
	for ( ; ; )
	{
		if (pObject->m_dwType == OBJECT_NULL)
			break;

		switch (pObject->m_dwType)
		{
		case OBJECT_CONTAINER:
			{
				tagObjContainer& ObjContainer = *(tagObjContainer*)pObject;

				switch (ObjContainer.m_dwContainerType)
				{
				case CONTAINER_NAMED:
					break;
				case CONTAINER_AIRPORT:
					ASSERT(0);
					break;
				case CONTAINER_VOR:
					BglFileRead2Vor(-1, ObjContainer.m_Object);
					break;
				case CONTAINER_NDB:
					BglFileRead2Ndb(-1, ObjContainer.m_Object);
					break;
				case CONTAINER_FIXPOINT:
					BglFileRead2Fix(-1, ObjContainer.m_Object);
					break;
				case CONTAINER_AIRWAY_V:
					BglFileRead2AirwayV(-1, ObjContainer.m_Object);
					break;
				case CONTAINER_AIRWAY_J:
					BglFileRead2AirwayJ(-1, ObjContainer.m_Object);
					break;
				default:
					ASSERT(0);
					break;
				}
				break;
			}
		case NAME_LIST:
			BglFileRead2NameList(pData, pObject);
			break;
		default:
			ASSERT(0);
			break;
		}

		pObject = (tagObject*)(pObject->m_cData + pObject->m_dwSize);
	}
}

void CScenCreate::BglFileRead2AirwayV(long lName, tagObject* pObject)
{
	for ( ; ; )
	{
		if (pObject->m_dwType == OBJECT_NULL)
			break;

		switch (pObject->m_dwType)
		{
		case ICAO_ID:
			{
				tagIcaoId& IcaoId = *(tagIcaoId*)pObject;

				break;
			}
		case LOCATION_AIRWAY:
			{
				tagLocationAirway& LocationAirway = *(tagLocationAirway*)pObject;

				break;
			}
		default:
			ASSERT(0);
			break;
		}

		pObject = (tagObject*)(pObject->m_cData + pObject->m_dwSize);
	}
}

void CScenCreate::BglFileRead2AirwayJ(long lName, tagObject* pObject)
{
	for ( ; ; )
	{
		if (pObject->m_dwType == OBJECT_NULL)
			break;

		switch (pObject->m_dwType)
		{
		case ICAO_ID:
			{
				tagIcaoId& IcaoId = *(tagIcaoId*)pObject;

				break;
			}
		case LOCATION_AIRWAY:
			{
				tagLocationAirway& LocationAirway = *(tagLocationAirway*)pObject;

				break;
			}
		default:
			ASSERT(0);
			break;
		}

		pObject = (tagObject*)(pObject->m_cData + pObject->m_dwSize);
	}
}

void CScenCreate::BglFileRead2Fix(long lName, tagObject* pObject)
{
	char szLast[10] = "";

	for ( ; ; )
	{
		if (pObject->m_dwType == OBJECT_NULL)
			break;

		switch (pObject->m_dwType)
		{
		case LOCATION_FIXPOINT:
			{
				tagLocationFix& LocationFix = *(tagLocationFix*)pObject;

				if (strcmp(LocationFix.m_szId, szLast) != 0)
				{
					strcpy(szLast, LocationFix.m_szId);
					double fLat = LocationFix.m_Lat.m_lHi * fMetersToDeg;
					double fLon = LocationFix.m_Lon.m_lHi * fQuadToLongitude;
					if (fLon > 180) fLon -= 360;
					char szId[6];
					strncpy(szId, &LocationFix.m_szId[2], min(5, pObject->m_cData + pObject->m_dwSize - &LocationFix.m_szId[2]))[5] = '\0';
					AddIsec(fLat, fLon, szId, 0);
				}
				break;
			}
		default:
			ASSERT(0);
			break;
		}

		pObject = (tagObject*)(pObject->m_cData + pObject->m_dwSize);
	}
}

void CScenCreate::BglFileRead2Airport(long lName, tagObject* pObject)
{
	double fLat, fLon;
	short nAlt;
	char szId[6] = "";

	for ( ; ; )
	{
		if (pObject->m_dwType == OBJECT_NULL)
			break;

		switch (pObject->m_dwType)
		{
		case LOCATION_AIRPORT:
			{
				tagLocationAirport& LocationAirport = *(tagLocationAirport*)pObject;
				fLat = LocationAirport.m_Lat.m_lHi * fMetersToDeg;
				fLon = LocationAirport.m_Lon.m_lHi * fQuadToLongitude;
				if (fLon > 180) fLon -= 360;
				nAlt = (short)LocationAirport.m_Alt.m_lHi;
				break;
			}
		case ICAO_ID:
			{
				tagIcaoId& IcaoId = *(tagIcaoId*)pObject;
				strncpy(szId, IcaoId.m_szId, min(5, pObject->m_cData + pObject->m_dwSize - IcaoId.m_szId))[5] = '\0';
				break;
			}
		case LOCATION_RUNWAY:
			pObject = BglFileRead2Runway(lName, pObject);
			continue;
			break;
		case LOCATION_SET:
			{
				tagLocationSet& LocationSet = *(tagLocationSet*)pObject;
				break;
			}
		case FREQUENCY:
			{
				tagFrequency& Frequency = *(tagFrequency*)pObject;

				switch (Frequency.m_dwTypeFreq)
				{
				case FREQ_ATIS:
					{
						double fFreq = BcdToDWord(Frequency.m_dwFreq >> 8) * 0.01;
						DWORD dwRunways = 0;
						AddAtis(fLat, fLon, dwRunways, fFreq, 0);
						break;
					}
				case FREQ_MULTICOM:
					break;
				case FREQ_UNICOM:
					break;
				case FREQ_CTAF:
					break;
				case FREQ_GNDCON:
					break;
				case FREQ_CT:
					break;
				case FREQ_CDEL:
					break;
				case FREQ_APCON:
					break;
				case FREQ_DEPCON:
					break;
				case FREQ_CENTER:
					break;
				case FREQ_FSS:
					break;
				case FREQ_AWOS:
					break;
				default:
					ASSERT(0);
					break;
				}
			}
			break;
		case LOCATION_TOWER:
			{
				tagLocationTower& LocationTower = *(tagLocationTower*)pObject;
				break;
			}
		case LOCATION_NAVAID:
		default:
			ASSERT(0);
			break;
		}

		pObject = (tagObject*)(pObject->m_cData + pObject->m_dwSize);
	}

	AddAirport(fLat, fLon, lName, nAlt, szId);
}

struct tagIls
{
	tagIls() { m_bLoc = m_bGs = m_bDme = false; m_wCode = 0; }
	bool m_bLoc, m_bGs, m_bDme;
	WORD m_wCode;
	double m_fLatLoc, m_fLonLoc, m_fLatGs, m_fLonGs, m_fLatDme, m_fLonDme;
	short m_nAltLoc, m_nAltGs, m_nAltDme, m_nAngleGs;
	WORD m_wLocDir;
	double m_fFreq;
	char m_szId[6];
};

tagObject* CScenCreate::BglFileRead2Runway(long lName, tagObject* pObject)
{
	tagLocationRunway& LocationRunway = *(tagLocationRunway*)pObject;

	double fLat = LocationRunway.m_Lat.m_lHi * fMetersToDeg;
	double fLon = LocationRunway.m_Lon.m_lHi * fQuadToLongitude;
	if (fLon > 180) fLon -= 360;
	short nAlt = (short)LocationRunway.m_Alt.m_lHi;
	WORD wCourse1 = WORD(LocationRunway.m_dwHead / 0x10000);
	WORD wLength = (WORD)LocationRunway.m_dwLength;
	WORD wWidth = (WORD)LocationRunway.m_dwWidth;

	double fLength = wLength * fFtToMeters;
	if (fLength > 300)
		fLength -= 60;
	double fCourse = wCourse1 * 360.0 / 0x10000;
	double fdy = fLength * cos(fCourse * fDegToRad);
	double fdx = fLength * sin(fCourse * fDegToRad);

	double fLat1 = fLat - (360 * fdy * .5 / fEarthCircumference);
	double fLon1 = fLon - (360 * fdx * .5 / (fEarthCircumference * cos(fLat * fDegToRad)));
	if (fLon1 > 180)
		fLon1 -= 360;
	else if (fLon1 < -180)
		fLon1 += 360;

	double fLat2 = fLat + (360 * fdy * .5 / fEarthCircumference);
	double fLon2 = fLon + (360 * fdx * .5 / (fEarthCircumference * cos(fLat * fDegToRad)));
	if (fLon2 > 180)
		fLon2 -= 360;
	else if (fLon2 < -180)
		fLon2 += 360;

	char szId1[6], szId2[6];

	if (LocationRunway.m_dwNumber <= 36)
	{
		BYTE uID1 = (BYTE)LocationRunway.m_dwNumber;

		if (LocationRunway.m_dwTypeRunway == RUNWAY)
			szId1[sprintf(szId1, "%u", uID1) + 1] = LocationRunway.m_Surface - 1;
		else if (LocationRunway.m_dwTypeRunway == RUNWAY_CENTER)
			szId1[sprintf(szId1, "%uC", uID1) + 1] = LocationRunway.m_Surface - 1;
		else if (LocationRunway.m_dwTypeRunway == RUNWAY_RIGHT)
			szId1[sprintf(szId1, "%uR", uID1) + 1] = LocationRunway.m_Surface - 1;
		else if (LocationRunway.m_dwTypeRunway == RUNWAY_LEFT)
			szId1[sprintf(szId1, "%uL", uID1) + 1] = LocationRunway.m_Surface - 1;
		else
			szId1[sprintf(szId1, "%u", uID1) + 1] = LocationRunway.m_Surface - 1;
	}
	else
	{
		double fCourse = wCourse1 * 360.0 / 0x10000;

		if (fCourse > 337.5 || fCourse <= 22.5)
			strcpy(szId1, "N");
		else if (fCourse > 22.5 && fCourse <= 67.5)
			strcpy(szId1, "NE");
		else if (fCourse > 67.5 && fCourse <= 112.5)
			strcpy(szId1, "E");
		else if (fCourse > 112.5 && fCourse <= 157.5)
			strcpy(szId1, "SE");
		else if (fCourse > 157.5 && fCourse <= 202.5)
			strcpy(szId1, "S");
		else if (fCourse > 202.5 && fCourse <= 245.5)
			strcpy(szId1, "SW");
		else if (fCourse > 245.5 && fCourse <= 292.5)
			strcpy(szId1, "W");
		else if (fCourse > 292.5 && fCourse <= 337.5)
			strcpy(szId1, "NW");
	}

	AddRunway(fLat1, fLon1, szId1, nAlt, wCourse1, wWidth, wLength);

	WORD wCourse2 = wCourse1 + 0x8000;

	if (LocationRunway.m_dwNumber <= 36)
	{
		BYTE uID1 = BYTE(LocationRunway.m_dwNumber + 18);
		if (uID1 > 36)
			uID1 -= 36;

		if (LocationRunway.m_dwTypeRunway == RUNWAY)
			szId2[sprintf(szId2, "%u", uID1) + 1] = LocationRunway.m_Surface - 1;
		else if (LocationRunway.m_dwTypeRunway == RUNWAY_CENTER)
			szId2[sprintf(szId2, "%uC", uID1) + 1] = LocationRunway.m_Surface - 1;
		else if (LocationRunway.m_dwTypeRunway == RUNWAY_RIGHT)
			szId2[sprintf(szId2, "%uL", uID1) + 1] = LocationRunway.m_Surface - 1;
		else if (LocationRunway.m_dwTypeRunway == RUNWAY_LEFT)
			szId2[sprintf(szId2, "%uR", uID1) + 1] = LocationRunway.m_Surface - 1;
		else
			szId2[sprintf(szId2, "%u", uID1) + 1] = LocationRunway.m_Surface - 1;
	}
	else
	{
		double fCourse = wCourse2 * 360.0 / 0x10000;

		if (fCourse > 337.5 || fCourse <= 22.5)
			strcpy(szId2, "N");
		else if (fCourse > 22.5 && fCourse <= 67.5)
			strcpy(szId2, "NE");
		else if (fCourse > 67.5 && fCourse <= 112.5)
			strcpy(szId2, "E");
		else if (fCourse > 112.5 && fCourse <= 157.5)
			strcpy(szId2, "SE");
		else if (fCourse > 157.5 && fCourse <= 202.5)
			strcpy(szId2, "S");
		else if (fCourse > 202.5 && fCourse <= 245.5)
			strcpy(szId2, "SW");
		else if (fCourse > 245.5 && fCourse <= 292.5)
			strcpy(szId2, "W");
		else if (fCourse > 292.5 && fCourse <= 337.5)
			strcpy(szId2, "NW");
	}

	AddRunway(fLat2, fLon2, szId2, nAlt, wCourse2, wWidth, wLength);

	pObject = (tagObject*)(pObject->m_cData + pObject->m_dwSize);

	CArray<tagIls, tagIls&> ArrayIls;

	for ( ; ; )
	{
		if (pObject->m_dwType != LOCATION_NAVAID)
			break;

		tagLocationNavaid& LocationNavaid = *(tagLocationNavaid*)pObject;

		switch (LocationNavaid.m_dwTypeNavaid)
		{
		case NAVAID_LOCALIZER:
			{
				tagIls& Ils = ArrayIls.ElementAt(ArrayIls.Add(tagIls()));
				Ils.m_bLoc = true;
				Ils.m_fLatLoc = LocationNavaid.m_Lat.m_lHi * fMetersToDeg;
				Ils.m_fLonLoc = LocationNavaid.m_Lon.m_lHi * fQuadToLongitude;
				if (Ils.m_fLonLoc > 180) Ils.m_fLonLoc -= 360;
				Ils.m_nAltLoc = (short)LocationNavaid.m_Alt.m_lHi;
				Ils.m_wLocDir = WORD(LocationNavaid.m_dwHead / 0x10000);
				Ils.m_fFreq = BcdToDWord(LocationNavaid.m_dwFreq >> 8) * 0.01;
				strncpy(Ils.m_szId, LocationNavaid.m_szId, min(5, pObject->m_cData + pObject->m_dwSize - LocationNavaid.m_szId))[5] = '\0';
			}
			break;
		case NAVAID_GLIDESLOPE:
			if (ArrayIls.GetUpperBound() >= 0 && !ArrayIls.ElementAt(ArrayIls.GetUpperBound()).m_bGs)
			{
				tagIls& Ils = ArrayIls.ElementAt(ArrayIls.GetUpperBound());
				Ils.m_bGs = true;
				Ils.m_wCode |= 0x0040;
				Ils.m_fLatGs = LocationNavaid.m_Lat.m_lHi * fMetersToDeg;
				Ils.m_fLonGs = LocationNavaid.m_Lon.m_lHi * fQuadToLongitude;
				if (Ils.m_fLonGs > 180) Ils.m_fLonGs -= 360;
				Ils.m_nAltGs = (short)LocationNavaid.m_Alt.m_lHi;
				double fAngelGs = LocationNavaid.m_dwHead / 0x10000 * 360.0 / 0x10000;
				Ils.m_nAngleGs = short(sin(fAngelGs * fDegToRad) * 2.0 * 0x10000);
			}
			else
				ASSERT(0);
			break;
		case NAVAID_DME:
			if (ArrayIls.GetUpperBound() >= 0 && !ArrayIls.ElementAt(ArrayIls.GetUpperBound()).m_bDme)
			{
				tagIls& Ils = ArrayIls.ElementAt(ArrayIls.GetUpperBound());
				Ils.m_bDme = true;
				Ils.m_wCode |= 0x0001;
				Ils.m_fLatDme = LocationNavaid.m_Lat.m_lHi * fMetersToDeg;
				Ils.m_fLonDme = LocationNavaid.m_Lon.m_lHi * fQuadToLongitude;
				if (Ils.m_fLonDme > 180) Ils.m_fLonDme -= 360;
				Ils.m_nAltDme = (short)LocationNavaid.m_Alt.m_lHi;
			}
			else
				ASSERT(0);
			break;
		case NAVAID_MARKER:
			{
				double fLat = LocationNavaid.m_Lat.m_lHi * fMetersToDeg;
				double fLon = LocationNavaid.m_Lon.m_lHi * fQuadToLongitude;
				if (fLon > 180) fLon -= 360;
				short nAlt = (short)LocationNavaid.m_Alt.m_lHi;
				WORD wHead = WORD(LocationNavaid.m_dwHead / 0x10000);

				switch (LocationNavaid.m_dwClass)
				{
				case MARKER_OM:
					AddMarker(MARKEROUTER, fLat, fLon, nAlt);
					break;
				case MARKER_MM:
					AddMarker(MARKERMIDDLE, fLat, fLon, nAlt);
					break;
				case MARKER_IM:
					AddMarker(MARKERINNER, fLat, fLon, nAlt);
					break;
				case MARKER_BC:
					AddMarker(MARKERBCOURSE, fLat, fLon, nAlt);
					break;
				default: ASSERT(0);
					break;
				}
				break;
			}
		default:
			ASSERT(0);
			break;
		}

		pObject = (tagObject*)(pObject->m_cData + pObject->m_dwSize);
	}

	for (int nIls = 0; nIls < ArrayIls.GetSize(); nIls++)
	{
		tagIls& Ils = ArrayIls.ElementAt(nIls);

		if (Ils.m_bLoc && Ils.m_bGs)
		{
			if (DeltaGrad(Ils.m_wLocDir * 360.0 / 0x10000, wCourse1 * 360.0 / 0x10000) < 10)
			{
				AddIls(fLat1, fLon1, Ils.m_szId, lName, Ils.m_nAltGs, Ils.m_fFreq, Ils.m_wLocDir, Ils.m_nAngleGs, (Ils.m_wCode << 8));
				if (m_bBcIls)
				{	// BC available
					AddIls(fLat2, fLon2, Ils.m_szId, lName, Ils.m_nAltGs, Ils.m_fFreq, Ils.m_wLocDir + 0x8000, -1, (Ils.m_wCode << 8));
					m_Ils.ElementAt(m_Ils.GetUpperBound()).m_bVisible = false;
				}
			}
			else if (DeltaGrad(Ils.m_wLocDir * 360.0 / 0x10000, wCourse2 * 360.0 / 0x10000) < 10)
			{
				AddIls(fLat2, fLon2, Ils.m_szId, lName, Ils.m_nAltGs, Ils.m_fFreq, Ils.m_wLocDir, Ils.m_nAngleGs, (Ils.m_wCode << 8));
				if (m_bBcIls)
				{	// BC available
					AddIls(fLat1, fLon1, Ils.m_szId, lName, Ils.m_nAltGs, Ils.m_fFreq, Ils.m_wLocDir + 0x8000, -1, (Ils.m_wCode << 8));
					m_Ils.ElementAt(m_Ils.GetUpperBound()).m_bVisible = false;
				}
			}
			else
				AddIls(Ils.m_fLatGs, Ils.m_fLonGs, Ils.m_szId, lName, Ils.m_nAltGs, Ils.m_fFreq, Ils.m_wLocDir, Ils.m_nAngleGs, (Ils.m_wCode << 8));
		}
		else if (Ils.m_bLoc)
		{
			if (DeltaGrad(Ils.m_wLocDir * 360.0 / 0x10000, wCourse1 * 360.0 / 0x10000) < 10)
			{
				AddIls(fLat1, fLon1, Ils.m_szId, lName, Ils.m_nAltLoc, Ils.m_fFreq, Ils.m_wLocDir, 0, (Ils.m_wCode << 8));
				if (m_bBcIls)
				{	// BC available
					AddIls(fLat2, fLon2, Ils.m_szId, lName, Ils.m_nAltGs, Ils.m_fFreq, Ils.m_wLocDir + 0x8000, -1, (Ils.m_wCode << 8));
					m_Ils.ElementAt(m_Ils.GetUpperBound()).m_bVisible = false;
				}
			}
			else if (DeltaGrad(Ils.m_wLocDir * 360.0 / 0x10000, wCourse2 * 360.0 / 0x10000) < 10)
			{
				AddIls(fLat2, fLon2, Ils.m_szId, lName, Ils.m_nAltLoc, Ils.m_fFreq, Ils.m_wLocDir, 0, (Ils.m_wCode << 8));
				if (m_bBcIls)
				{	// BC available
					AddIls(fLat1, fLon1, Ils.m_szId, lName, Ils.m_nAltGs, Ils.m_fFreq, Ils.m_wLocDir + 0x8000, -1, (Ils.m_wCode << 8));
					m_Ils.ElementAt(m_Ils.GetUpperBound()).m_bVisible = false;
				}
			}
			else
				AddIls(Ils.m_fLatLoc, Ils.m_fLonLoc, Ils.m_szId, lName, Ils.m_nAltLoc, Ils.m_fFreq, Ils.m_wLocDir, 0, (Ils.m_wCode << 8));
		}
		else
			ASSERT(0);
	}

	return pObject;
}

void CScenCreate::BglFileRead2Vor(long lName, tagObject* pObject)
{
	double fLat, fLon, fFreq;
	short nAlt;
	char szId[6];
	WORD wCode = 0x0008;

	for ( ; ; )
	{
		if (pObject->m_dwType == OBJECT_NULL)
			break;

		switch (pObject->m_dwType)
		{
		case LOCATION_NAVAID:
			{
				tagLocationNavaid& LocationNavaid = *(tagLocationNavaid*)pObject;

				switch (LocationNavaid.m_dwTypeNavaid)
				{
				case NAVAID_TACAN:
					wCode |= 0x0002;
					break;
				case NAVAID_VOR:
					{
						wCode &= ~0x0008;
						fLat = LocationNavaid.m_Lat.m_lHi * fMetersToDeg;
						fLon = LocationNavaid.m_Lon.m_lHi * fQuadToLongitude;
						if (fLon > 180) fLon -= 360;
						nAlt = (short)LocationNavaid.m_Alt.m_lHi;
						fFreq = BcdToDWord(LocationNavaid.m_dwFreq >> 8) * 0.01;
						strncpy(szId, LocationNavaid.m_szId, min(5, pObject->m_cData + pObject->m_dwSize - LocationNavaid.m_szId))[5] = '\0';
						break;
					}
				case NAVAID_DME:
					{
						wCode |= 0x0001;
						fLat = LocationNavaid.m_Lat.m_lHi * fMetersToDeg;
						fLon = LocationNavaid.m_Lon.m_lHi * fQuadToLongitude;
						if (fLon > 180) fLon -= 360;
						nAlt = (short)LocationNavaid.m_Alt.m_lHi;
						fFreq = BcdToDWord(LocationNavaid.m_dwFreq >> 8) * 0.01;
						strncpy(szId, LocationNavaid.m_szId, min(5, pObject->m_cData + pObject->m_dwSize - LocationNavaid.m_szId))[5] = '\0';
						break;
					}
				default:
					ASSERT(0);
					break;
				}
				break;
			}
		default:
			ASSERT(0);
			break;
		}

		pObject = (tagObject*)(pObject->m_cData + pObject->m_dwSize);
	}

	AddVor(fLat, fLon, szId, lName >= 0 ? lName : m_NameFile.PutString(szId), nAlt, fFreq, 0, (wCode << 8));
}

void CScenCreate::BglFileRead2Ndb(long lName, tagObject* pObject)
{
	for ( ; ; )
	{
		if (pObject->m_dwType == OBJECT_NULL)
			break;

		switch (pObject->m_dwType)
		{
		case LOCATION_NAVAID:
			{
				tagLocationNavaid& LocationNavaid = *(tagLocationNavaid*)pObject;

				switch (LocationNavaid.m_dwTypeNavaid)
				{
				case NAVAID_NDB:
					{
						double fLat = LocationNavaid.m_Lat.m_lHi * fMetersToDeg;
						double fLon = LocationNavaid.m_Lon.m_lHi * fQuadToLongitude;
						if (fLon > 180) fLon -= 360;
						short nAlt = (short)LocationNavaid.m_Alt.m_lHi;
						double fFreq = BcdToDWord(LocationNavaid.m_dwFreq >> 4);
						char szId[6];
						strncpy(szId, LocationNavaid.m_szId, min(5, pObject->m_cData + pObject->m_dwSize - LocationNavaid.m_szId))[5] = '\0';
						AddNdb(fLat, fLon, szId, lName >= 0 ? lName : m_NameFile.PutString(szId), nAlt, fFreq, 0);
						break;
					}
				default:
					ASSERT(0);
					break;
				}
				break;
			}
		default:
			ASSERT(0);
			break;
		}

		pObject = (tagObject*)(pObject->m_cData + pObject->m_dwSize);
	}
}
