///////////////////////////////////////////////////
// !!!Open source!!! Use the file at your own risk.
///////////////////////////////////////////////////

#include <windows.h>
#include <stdio.h>
#include <math.h>

#include "resource.h"
#include "..\Global\FSNavFlp.h"

#ifdef __cplusplus
extern "C" {
#endif

const char APP_NAME[]		= "ACS-GPS";
const char INITIAL_DIR[]	= "InitialDir";
const char TO_FILE[]		= "ToFile";

HANDLE hThisModule;
char szIniFilePath[_MAX_PATH];

BOOL WINAPI DllMain(HANDLE hModule, DWORD dwReason, LPVOID lpReserved)
{
	char* pszTmp;

    switch(dwReason)
	{
    case DLL_PROCESS_ATTACH:
		hThisModule = hModule;

		if (GetModuleFileName(hThisModule, szIniFilePath, _MAX_PATH) == 0)
			return FALSE;

		pszTmp = strrchr(szIniFilePath, '\\');
		if (pszTmp == NULL)
			return FALSE;

		strcpy(pszTmp + 1, INI_FILE_NAME);
		break;
    case DLL_THREAD_ATTACH:
		break;
    case DLL_THREAD_DETACH:
		break;
    case DLL_PROCESS_DETACH:
		break;
    }
    return TRUE;
}

BOOL CALLBACK DialogProcOptions(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	WORD wNotifyCode, wID;
	HWND hwndCtl;
	char szTmp[1000];
	LRESULT lResult;

	switch (uMsg)
	{
	case WM_INITDIALOG:
		strcpy(szTmp, APP_NAME);
		strcat(szTmp, " ");
		GetWindowText(hwndDlg, &szTmp[strlen(szTmp)], sizeof(szTmp) - strlen(szTmp));
		SetWindowText(hwndDlg, szTmp);

		GetPrivateProfileString(APP_NAME, TO_FILE, "0", szTmp, sizeof(szTmp), szIniFilePath);
		SendMessage(GetDlgItem(hwndDlg, IDC_TOFILE), BM_SETCHECK, (szTmp[0] == '0' ? BST_UNCHECKED : BST_CHECKED), 0);
		break;
	case WM_COMMAND:
		wNotifyCode = HIWORD(wParam);
		wID = LOWORD(wParam);
		hwndCtl = (HWND)lParam;

		if (hwndCtl != NULL && wNotifyCode == BN_CLICKED)
		{
			switch (wID)
			{
			case IDCANCEL:
				EndDialog(hwndDlg, IDCANCEL);
				return 1;
				break;
			case IDOK:
				EndDialog(hwndDlg, IDOK);

				lResult = SendMessage(GetDlgItem(hwndDlg, IDC_TOFILE), BM_GETCHECK, 0, 0);
				WritePrivateProfileString(APP_NAME, TO_FILE, (lResult == BST_CHECKED ? "1" : "0"), szIniFilePath);
				return 1;
				break;
			}
		}
		break;
	}

	return 0;
}

void __stdcall Options(const PVOID pFlightPlan, HWND hwndParent)
{
	DialogBox(hThisModule, MAKEINTRESOURCE(IDD_OPTIONS), hwndParent, DialogProcOptions);
}

BOOL Export1(const PVOID pFlightPlan, HWND hwndParent, FILE* pFile)
{
	FLPX_WAYPOINT	WayPoint = { sizeof(FLPX_WAYPOINT) };
	char			szTmp[100];
	char*			pszTmp;
	int				nVal;
	double			fVal;
	int				nCommand;

	for (nCommand = FLPX_GETFIRST; FlpxGetWaypoint(pFlightPlan, nCommand, &WayPoint); nCommand = FLPX_GETNEXT)
	{
		if (fprintf(pFile, "%.5s\n", WayPoint.m_szId) < 0)
			return FALSE;

		if (WayPoint.m_cType == WPTYPE_NDB)
		{
			for (strcpy(szTmp, WayPoint.m_szName); strlen(szTmp) > 13; )
			{
				if ((pszTmp = strrchr(szTmp, ' ')) == NULL || pszTmp - szTmp < 6)
					szTmp[13] = '\0';
				else
					*pszTmp = '\0';
			}

			if (fprintf(pFile, "%-14s%06.1f\n", szTmp, WayPoint.m_fFreq) < 0)
				return FALSE;
		}
		else if (WayPoint.m_cType == WPTYPE_VORTAC || WayPoint.m_cType == WPTYPE_VORDME ||
				 WayPoint.m_cType == WPTYPE_DME || WayPoint.m_cType == WPTYPE_VOR ||
				 WayPoint.m_cType == WPTYPE_ILS || WayPoint.m_cType == WPTYPE_ILSGS ||
				 WayPoint.m_cType == WPTYPE_ATIS ||
				 (WayPoint.m_cType == WPTYPE_RWY && nCommand != FLPX_GETFIRST))
		{
			for (strcpy(szTmp, WayPoint.m_szName); strlen(szTmp) > 13; )
			{
				if ((pszTmp = strrchr(szTmp, ' ')) == NULL || pszTmp - szTmp < 6)
					szTmp[13] = '\0';
				else
					*pszTmp = '\0';
			}

			if (fprintf(pFile, "%-14s%05.2f\n", szTmp, WayPoint.m_fFreq) < 0)
				return FALSE;
		}
		else
		{
			if (fprintf(pFile, "%.20s\n", WayPoint.m_szName) < 0)
				return FALSE;
		}

		WayPoint.m_fLon = (int)WayPoint.m_fLon + floor((WayPoint.m_fLon - (int)WayPoint.m_fLon) * 60 * 100 + .5) / 60 / 100;
		nVal = (int)WayPoint.m_fLon;
		fVal = (WayPoint.m_fLon - nVal) * 60;
		if (fprintf(pFile, "%c%3d* %0.2fm\n", (WayPoint.m_fLon >= 0 ? 'E' : 'W'), abs(nVal), fabs(fVal)) < 0)
			return FALSE;

		WayPoint.m_fLat = (int)WayPoint.m_fLat + floor((WayPoint.m_fLat - (int)WayPoint.m_fLat) * 60 * 100 + .5) / 60 / 100;
		nVal = (int)WayPoint.m_fLat;
		fVal = (WayPoint.m_fLat - nVal) * 60;
		if (fprintf(pFile, "%c%3d* %0.2fm\n\n", (WayPoint.m_fLat >= 0 ? 'N' : 'S'), abs(nVal), fabs(fVal)) < 0)
			return FALSE;
	}

	return TRUE;
}

BOOL __stdcall Export(const PVOID pFlightPlan, HWND hwndParent)
{
	FLPX_WAYPOINT	WayPoint = { sizeof(FLPX_WAYPOINT) };
	FILE*			pFile;
	char			szInitialDir[_MAX_PATH], szFileName[_MAX_PATH], szTmp[100];
	char*			pszTmp;
	BOOL			bResult = TRUE;

	if (!FlpxGetWaypoint(pFlightPlan, FLPX_GETFIRST, &WayPoint))
		return FALSE;

	GetPrivateProfileString(APP_NAME, TO_FILE, "0", szTmp, sizeof(szTmp), szIniFilePath);

	if (szTmp[0] != '0')
	{
		GetPrivateProfileString(APP_NAME, INITIAL_DIR, "", szInitialDir, sizeof(szInitialDir), szIniFilePath);

		sprintf(szTmp, "%s Flight Plan (*.prg)|*.prg|All Files (*.*)|*.*||", APP_NAME);
		if (!FlpxDlgSaveAs(szFileName, hwndParent, szTmp, szInitialDir, "prg", NULL))
			return TRUE;

		strcpy(szInitialDir, szFileName);
		if (pszTmp = strrchr(szInitialDir, '\\'))
			*(pszTmp + 1) = '\0';
		WritePrivateProfileString(APP_NAME, INITIAL_DIR, szInitialDir, szIniFilePath);
	}
	else
	{
		strcpy(szFileName, szIniFilePath);

		pszTmp = strrchr(szFileName, '\\');
		if (pszTmp == NULL)
			return FALSE;

		*pszTmp = '\0';

		pszTmp = strrchr(szFileName, '\\');
		if (pszTmp == NULL)
			return FALSE;

		*pszTmp = '\0';

		pszTmp = strrchr(szFileName, '\\');
		if (pszTmp == NULL)
			return FALSE;

		*pszTmp = '\0';

		pszTmp = strrchr(szFileName, '\\');
		if (pszTmp == NULL)
			return FALSE;

		strcpy(pszTmp + 1, "acs-gps.dat");
	}

	if ((pFile = fopen(szFileName, "wt")) == NULL)
		return FALSE;

	bResult = Export1(pFlightPlan, hwndParent, pFile);

	if (fclose(pFile) == EOF)
		bResult = FALSE;

	return bResult;
}

FLPX_IMPORT_TABLE FlpxImportTable =
{
	sizeof(FLPX_IMPORT_TABLE),
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};

FLPX_EXPORT_TABLE FlpxExportTable =
{
	sizeof(FLPX_EXPORT_TABLE),
	APP_NAME,
	Options,
	Export
};

#ifdef __cplusplus
}
#endif
